/*
	Generate all KS C 5601-1987 Hangul(or Hanja) codes.

	KS C 5601-1987 Hangul code range
		high byte : 0xb0 - 0xc8
		low  byte : 0xa1 - 0xfe

	KS C 5601-1987 Hanja code range
		high byte : 0xca - 0xfd
		low  byte : 0xa1 - 0xfe

	KS C 5601-1987 Jamo, symbol, ...
		high byte : 0xa1 - 0xac
		low  byte : 0xa1 - 0xfe  --->  ???

	You can use this program to generate KS C 5601-1987 Hanja codes
		only by modifying 'high byte' range.
	Then, convert Hanja to Hangul using HWP wordprocessor.
	In this case, some Hanja's are mis-converted
		because of the pronunciation problem.
	Pronunciation problem should be corrected manually.
		(In 'hanjatab.h', I did it myself.)
	And then, run 'mk-htab.exe'.
*/

#include <stdio.h>

main()
{
	unsigned i, j;

	for (i = 0xa1; i <= 0xac; i++) {
		for (j = 0xa1; j <= 0xfe; j++)
			printf("%x%x %c%c\n", i, j, i, j);
	}
}
