/*
	KSC5601 <--> KSSM code conversion table for
		Chosong, Junsong, Jongsong-only syllables.

	KS C 5601-1987 morden Jamo range is (a4:a1-d3) : 51 chars

		1997. 1. 7.	Kang, Seung-Shik	Hansung Universty
*/

unsigned short jamo[51][2] = {
	0xa4a1, 0x8841,	/*  */
	0xa4a2, 0x8c41,	/*  */
	0xa4a4, 0x9041,	/*  */
	0xa4a7, 0x9441,	/* */
	0xa4a8, 0x9841,	/*  */
	0xa4a9, 0x9c41,	/*  */
	0xa4b1, 0xa041,	/*  */
	0xa4b2, 0xa441,	/*  */
	0xa4b3, 0xa841,	/*  */
	0xa4b5, 0xac41,	/*  */
	0xa4b6, 0xb041,	/*  */
	0xa4b7, 0xb441,	/*  */
	0xa4b8, 0xb841,	/*  */
	0xa4b9, 0xbc41,	/*  */
	0xa4ba, 0xc041,	/*  */
	0xa4bb, 0xc441,	/*  */
	0xa4bc, 0xc841,	/*  */
	0xa4bd, 0xcc41,	/*  */
	0xa4be, 0xd041,	/*  */	/* Chosung 19 */

	0xa4bf, 0x8461,	/*  */
	0xa4c0, 0x8481,	/*  */
	0xa4c1, 0x84a1,	/*  */
	0xa4c2, 0x84c1,	/*  */
	0xa4c3, 0x84e1,	/*  */
	0xa4c4, 0x8541,	/*  */
	0xa4c5, 0x8561,	/*  */
	0xa4c6, 0x8581,	/*  */
	0xa4c7, 0x85a1,	/*  */
	0xa4c8, 0x85c1,	/*  */
	0xa4c9, 0x85e1,	/*  */
	0xa4ca, 0x8641,	/*  */
	0xa4cb, 0x8661,	/*  */
	0xa4cc, 0x8681,	/*  */
	0xa4cd, 0x86a1,	/*  */
	0xa4ce, 0x86c1,	/*  */
	0xa4cf, 0x86e1,	/*  */
	0xa4d0, 0x8741,	/*  */
	0xa4d1, 0x8761,	/*  */
	0xa4d2, 0x8781,	/*  */
	0xa4d3, 0x87a1,	/*  */	/* Jungsung 21 */

	0xa4a3, 0x8444,	/*  */
	0xa4a5, 0x8446,	/* */
	0xa4a6, 0x8447,	/*  */
	0xa4aa, 0x844a,	/*  */
	0xa4ab, 0x844b,	/*  */
	0xa4ac, 0x844c,	/*  */
	0xa4ad, 0x844d,	/*  */
	0xa4ae, 0x844e,	/*  */
	0xa4af, 0x844f,	/*  */
	0xa4b0, 0x8450,	/*  */
	0xa4b4, 0x8454	/*  */	/* Jongsung 27 11 */
};

/*
	KSC5601 <--> KSSM Hangul code conversion table.
	2,350 char.s defined in KS C 5601-1987 are listed here.

	KS C 5601-1987 modern character range is (B0-C8:A1-FE) : 2,350 chars

		1996. 12. 13.	Kang, Seung-Shik	Hansung Universty
*/
unsigned short hcode[2350][2] = {
	0xb0a1, 0x8861,	/*  */
	0xb0a2, 0x8862,	/*  */
	0xb0a3, 0x8865,	/*  */
	0xb0a4, 0x8868,	/*  */
	0xb0a5, 0x8869,	/*  */
	0xb0a6, 0x886a,	/*  */
	0xb0a7, 0x886b,	/*  */
	0xb0a8, 0x8871,	/*  */
	0xb0a9, 0x8873,	/*  */
	0xb0aa, 0x8874,	/*  */
	0xb0ab, 0x8875,	/*  */
	0xb0ac, 0x8876,	/*  */
	0xb0ad, 0x8877,	/*  */
	0xb0ae, 0x8878,	/*  */
	0xb0af, 0x8879,	/*  */
	0xb0b0, 0x887b,	/*  */
	0xb0b1, 0x887c,	/*  */
	0xb0b2, 0x887d,	/*  */
	0xb0b3, 0x8881,	/*  */
	0xb0b4, 0x8882,	/*  */
	0xb0b5, 0x8885,	/*  */
	0xb0b6, 0x8889,	/*  */
	0xb0b7, 0x8891,	/*  */
	0xb0b8, 0x8893,	/*  */
	0xb0b9, 0x8895,	/*  */
	0xb0ba, 0x8896,	/*  */
	0xb0bb, 0x8897,	/*  */
	0xb0bc, 0x88a1,	/*  */
	0xb0bd, 0x88a2,	/*  */
	0xb0be, 0x88a5,	/*  */
	0xb0bf, 0x88a9,	/*  */
	0xb0c0, 0x88b5,	/*  */
	0xb0c1, 0x88b7,	/*  */
	0xb0c2, 0x88c1,	/*  */
	0xb0c3, 0x88c5,	/*  */
	0xb0c4, 0x88c9,	/*  */
	0xb0c5, 0x88e1,	/*  */
	0xb0c6, 0x88e2,	/*  */
	0xb0c7, 0x88e5,	/*  */
	0xb0c8, 0x88e8,	/*  */
	0xb0c9, 0x88e9,	/*  */
	0xb0ca, 0x88eb,	/*  */
	0xb0cb, 0x88f1,	/*  */
	0xb0cc, 0x88f3,	/*  */
	0xb0cd, 0x88f5,	/*  */
	0xb0ce, 0x88f6,	/*  */
	0xb0cf, 0x88f7,	/*  */
	0xb0d0, 0x88f8,	/*  */
	0xb0d1, 0x88fb,	/*  */
	0xb0d2, 0x88fc,	/*  */
	0xb0d3, 0x88fd,	/*  */
	0xb0d4, 0x8941,	/*  */
	0xb0d5, 0x8945,	/*  */
	0xb0d6, 0x8949,	/*  */
	0xb0d7, 0x8951,	/*  */
	0xb0d8, 0x8953,	/*  */
	0xb0d9, 0x8955,	/*  */
	0xb0da, 0x8956,	/*  */
	0xb0db, 0x8957,	/*  */
	0xb0dc, 0x8961,	/*  */
	0xb0dd, 0x8962,	/*  */
	0xb0de, 0x8963,	/*  */
	0xb0df, 0x8965,	/*  */
	0xb0e0, 0x8968,	/*  */
	0xb0e1, 0x8969,	/*  */
	0xb0e2, 0x8971,	/*  */
	0xb0e3, 0x8973,	/*  */
	0xb0e4, 0x8975,	/*  */
	0xb0e5, 0x8976,	/*  */
	0xb0e6, 0x8977,	/*  */
	0xb0e7, 0x897b,	/*  */
	0xb0e8, 0x8981,	/*  */
	0xb0e9, 0x8985,	/*  */
	0xb0ea, 0x8989,	/*  */
	0xb0eb, 0x8993,	/*  */
	0xb0ec, 0x8995,	/*  */
	0xb0ed, 0x89a1,	/*  */
	0xb0ee, 0x89a2,	/*  */
	0xb0ef, 0x89a5,	/*  */
	0xb0f0, 0x89a8,	/*  */
	0xb0f1, 0x89a9,	/*  */
	0xb0f2, 0x89ab,	/*  */
	0xb0f3, 0x89ad,	/*  */
	0xb0f4, 0x89b0,	/*  */
	0xb0f5, 0x89b1,	/*  */
	0xb0f6, 0x89b3,	/*  */
	0xb0f7, 0x89b5,	/*  */
	0xb0f8, 0x89b7,	/*  */
	0xb0f9, 0x89b8,	/*  */
	0xb0fa, 0x89c1,	/*  */
	0xb0fb, 0x89c2,	/*  */
	0xb0fc, 0x89c5,	/*  */
	0xb0fd, 0x89c9,	/*  */
	0xb0fe, 0x89cb,	/*  */
	0xb1a1, 0x89d1,	/*  */
	0xb1a2, 0x89d3,	/*  */
	0xb1a3, 0x89d5,	/*  */
	0xb1a4, 0x89d7,	/*  */
	0xb1a5, 0x89e1,	/*  */
	0xb1a6, 0x89e5,	/*  */
	0xb1a7, 0x89e9,	/*  */
	0xb1a8, 0x89f3,	/*  */
	0xb1a9, 0x89f6,	/*  */
	0xb1aa, 0x89f7,	/*  */
	0xb1ab, 0x8a41,	/*  */
	0xb1ac, 0x8a42,	/*  */
	0xb1ad, 0x8a45,	/*  */
	0xb1ae, 0x8a49,	/*  */
	0xb1af, 0x8a51,	/*  */
	0xb1b0, 0x8a53,	/*  */
	0xb1b1, 0x8a55,	/*  */
	0xb1b2, 0x8a57,	/*  */
	0xb1b3, 0x8a61,	/*  */
	0xb1b4, 0x8a65,	/*  */
	0xb1b5, 0x8a69,	/*  */
	0xb1b6, 0x8a73,	/*  */
	0xb1b7, 0x8a75,	/*  */
	0xb1b8, 0x8a81,	/*  */
	0xb1b9, 0x8a82,	/*  */
	0xb1ba, 0x8a85,	/*  */
	0xb1bb, 0x8a88,	/*  */
	0xb1bc, 0x8a89,	/*  */
	0xb1bd, 0x8a8a,	/*  */
	0xb1be, 0x8a8b,	/*  */
	0xb1bf, 0x8a90,	/*  */
	0xb1c0, 0x8a91,	/*  */
	0xb1c1, 0x8a93,	/*  */
	0xb1c2, 0x8a95,	/*  */
	0xb1c3, 0x8a97,	/*  */
	0xb1c4, 0x8a98,	/*  */
	0xb1c5, 0x8aa1,	/*  */
	0xb1c6, 0x8aa2,	/*  */
	0xb1c7, 0x8aa5,	/*  */
	0xb1c8, 0x8aa9,	/*  */
	0xb1c9, 0x8ab6,	/*  */
	0xb1ca, 0x8ab7,	/*  */
	0xb1cb, 0x8ac1,	/*  */
	0xb1cc, 0x8ad5,	/*  */
	0xb1cd, 0x8ae1,	/*  */
	0xb1ce, 0x8ae2,	/*  */
	0xb1cf, 0x8ae5,	/*  */
	0xb1d0, 0x8ae9,	/*  */
	0xb1d1, 0x8af1,	/*  */
	0xb1d2, 0x8af3,	/*  */
	0xb1d3, 0x8af5,	/*  */
	0xb1d4, 0x8b41,	/*  */
	0xb1d5, 0x8b45,	/*  */
	0xb1d6, 0x8b49,	/*  */
	0xb1d7, 0x8b61,	/*  */
	0xb1d8, 0x8b62,	/*  */
	0xb1d9, 0x8b65,	/*  */
	0xb1da, 0x8b68,	/*  */
	0xb1db, 0x8b69,	/*  */
	0xb1dc, 0x8b6a,	/*  */
	0xb1dd, 0x8b71,	/*  */
	0xb1de, 0x8b73,	/*  */
	0xb1df, 0x8b75,	/*  */
	0xb1e0, 0x8b77,	/*  */
	0xb1e1, 0x8b81,	/*  */
	0xb1e2, 0x8ba1,	/*  */
	0xb1e3, 0x8ba2,	/*  */
	0xb1e4, 0x8ba5,	/*  */
	0xb1e5, 0x8ba8,	/*  */
	0xb1e6, 0x8ba9,	/*  */
	0xb1e7, 0x8bab,	/*  */
	0xb1e8, 0x8bb1,	/*  */
	0xb1e9, 0x8bb3,	/*  */
	0xb1ea, 0x8bb5,	/*  */
	0xb1eb, 0x8bb7,	/*  */
	0xb1ec, 0x8bb8,	/*  */
	0xb1ed, 0x8bbc,	/*  */
	0xb1ee, 0x8c61,	/*  */
	0xb1ef, 0x8c62,	/*  */
	0xb1f0, 0x8c63,	/*  */
	0xb1f1, 0x8c65,	/*  */
	0xb1f2, 0x8c69,	/*  */
	0xb1f3, 0x8c6b,	/*  */
	0xb1f4, 0x8c71,	/*  */
	0xb1f5, 0x8c73,	/*  */
	0xb1f6, 0x8c75,	/*  */
	0xb1f7, 0x8c76,	/*  */
	0xb1f8, 0x8c77,	/*  */
	0xb1f9, 0x8c7b,	/*  */
	0xb1fa, 0x8c81,	/*  */
	0xb1fb, 0x8c82,	/*  */
	0xb1fc, 0x8c85,	/*  */
	0xb1fd, 0x8c89,	/*  */
	0xb1fe, 0x8c91,	/*  */
	0xb2a1, 0x8c93,	/*  */
	0xb2a2, 0x8c95,	/*  */
	0xb2a3, 0x8c96,	/*  */
	0xb2a4, 0x8c97,	/*  */
	0xb2a5, 0x8ca1,	/*  */
	0xb2a6, 0x8ca2,	/*  */
	0xb2a7, 0x8ca9,	/*  */
	0xb2a8, 0x8ce1,	/*  */
	0xb2a9, 0x8ce2,	/*  */
	0xb2aa, 0x8ce3,	/*  */
	0xb2ab, 0x8ce5,	/*  */
	0xb2ac, 0x8ce9,	/*  */
	0xb2ad, 0x8cf1,	/*  */
	0xb2ae, 0x8cf3,	/*  */
	0xb2af, 0x8cf5,	/*  */
	0xb2b0, 0x8cf6,	/*  */
	0xb2b1, 0x8cf7,	/*  */
	0xb2b2, 0x8d41,	/*  */
	0xb2b3, 0x8d42,	/*  */
	0xb2b4, 0x8d45,	/*  */
	0xb2b5, 0x8d51,	/*  */
	0xb2b6, 0x8d55,	/*  */
	0xb2b7, 0x8d57,	/*  */
	0xb2b8, 0x8d61,	/*  */
	0xb2b9, 0x8d65,	/*  */
	0xb2ba, 0x8d69,	/*  */
	0xb2bb, 0x8d75,	/*  */
	0xb2bc, 0x8d76,	/*  */
	0xb2bd, 0x8d7b,	/*  */
	0xb2be, 0x8d81,	/*  */
	0xb2bf, 0x8da1,	/*  */
	0xb2c0, 0x8da2,	/*  */
	0xb2c1, 0x8da5,	/*  */
	0xb2c2, 0x8da7,	/*  */
	0xb2c3, 0x8da9,	/*  */
	0xb2c4, 0x8db1,	/*  */
	0xb2c5, 0x8db3,	/*  */
	0xb2c6, 0x8db5,	/*  */
	0xb2c7, 0x8db7,	/*  */
	0xb2c8, 0x8db8,	/*  */
	0xb2c9, 0x8db9,	/*  */
	0xb2ca, 0x8dc1,	/*  */
	0xb2cb, 0x8dc2,	/*  */
	0xb2cc, 0x8dc9,	/*  */
	0xb2cd, 0x8dd6,	/*  */
	0xb2ce, 0x8dd7,	/*  */
	0xb2cf, 0x8de1,	/*  */
	0xb2d0, 0x8de2,	/*  */
	0xb2d1, 0x8df7,	/*  */
	0xb2d2, 0x8e41,	/*  */
	0xb2d3, 0x8e45,	/*  */
	0xb2d4, 0x8e49,	/*  */
	0xb2d5, 0x8e51,	/*  */
	0xb2d6, 0x8e53,	/*  */
	0xb2d7, 0x8e57,	/*  */
	0xb2d8, 0x8e61,	/*  */
	0xb2d9, 0x8e81,	/*  */
	0xb2da, 0x8e82,	/*  */
	0xb2db, 0x8e85,	/*  */
	0xb2dc, 0x8e89,	/*  */
	0xb2dd, 0x8e90,	/*  */
	0xb2de, 0x8e91,	/*  */
	0xb2df, 0x8e93,	/*  */
	0xb2e0, 0x8e95,	/*  */
	0xb2e1, 0x8e97,	/*  */
	0xb2e2, 0x8e98,	/*  */
	0xb2e3, 0x8ea1,	/*  */
	0xb2e4, 0x8ea9,	/*  */
	0xb2e5, 0x8eb6,	/*  */
	0xb2e6, 0x8eb7,	/*  */
	0xb2e7, 0x8ec1,	/*  */
	0xb2e8, 0x8ec2,	/*  */
	0xb2e9, 0x8ec5,	/*  */
	0xb2ea, 0x8ec9,	/*  */
	0xb2eb, 0x8ed1,	/*  */
	0xb2ec, 0x8ed3,	/*  */
	0xb2ed, 0x8ed6,	/*  */
	0xb2ee, 0x8ee1,	/*  */
	0xb2ef, 0x8ee5,	/*  */
	0xb2f0, 0x8ee9,	/*  */
	0xb2f1, 0x8ef1,	/*  */
	0xb2f2, 0x8ef3,	/*  */
	0xb2f3, 0x8f41,	/*  */
	0xb2f4, 0x8f61,	/*  */
	0xb2f5, 0x8f62,	/*  */
	0xb2f6, 0x8f65,	/*  */
	0xb2f7, 0x8f67,	/*  */
	0xb2f8, 0x8f69,	/*  */
	0xb2f9, 0x8f6b,	/*  */
	0xb2fa, 0x8f70,	/*  */
	0xb2fb, 0x8f71,	/*  */
	0xb2fc, 0x8f73,	/*  */
	0xb2fd, 0x8f75,	/*  */
	0xb2fe, 0x8f77,	/*  */
	0xb3a1, 0x8f7b,	/*  */
	0xb3a2, 0x8fa1,	/*  */
	0xb3a3, 0x8fa2,	/*  */
	0xb3a4, 0x8fa5,	/*  */
	0xb3a5, 0x8fa9,	/*  */
	0xb3a6, 0x8fb1,	/*  */
	0xb3a7, 0x8fb3,	/*  */
	0xb3a8, 0x8fb5,	/*  */
	0xb3a9, 0x8fb7,	/*  */
	0xb3aa, 0x9061,	/*  */
	0xb3ab, 0x9062,	/*  */
	0xb3ac, 0x9063,	/*  */
	0xb3ad, 0x9065,	/*  */
	0xb3ae, 0x9068,	/*  */
	0xb3af, 0x9069,	/*  */
	0xb3b0, 0x906a,	/*  */
	0xb3b1, 0x906b,	/*  */
	0xb3b2, 0x9071,	/*  */
	0xb3b3, 0x9073,	/*  */
	0xb3b4, 0x9075,	/*  */
	0xb3b5, 0x9076,	/*  */
	0xb3b6, 0x9077,	/*  */
	0xb3b7, 0x9078,	/*  */
	0xb3b8, 0x9079,	/*  */
	0xb3b9, 0x907b,	/*  */
	0xb3ba, 0x907d,	/*  */
	0xb3bb, 0x9081,	/*  */
	0xb3bc, 0x9082,	/*  */
	0xb3bd, 0x9085,	/*  */
	0xb3be, 0x9089,	/*  */
	0xb3bf, 0x9091,	/*  */
	0xb3c0, 0x9093,	/*  */
	0xb3c1, 0x9095,	/*  */
	0xb3c2, 0x9096,	/*  */
	0xb3c3, 0x9097,	/*  */
	0xb3c4, 0x90a1,	/*  */
	0xb3c5, 0x90a2,	/*  */
	0xb3c6, 0x90a5,	/*  */
	0xb3c7, 0x90a9,	/*  */
	0xb3c8, 0x90b1,	/*  */
	0xb3c9, 0x90b7,	/*  */
	0xb3ca, 0x90e1,	/*  */
	0xb3cb, 0x90e2,	/*  */
	0xb3cc, 0x90e4,	/*  */
	0xb3cd, 0x90e5,	/*  */
	0xb3ce, 0x90e9,	/*  */
	0xb3cf, 0x90eb,	/*  */
	0xb3d0, 0x90ec,	/*  */
	0xb3d1, 0x90f1,	/*  */
	0xb3d2, 0x90f3,	/*  */
	0xb3d3, 0x90f5,	/*  */
	0xb3d4, 0x90f6,	/*  */
	0xb3d5, 0x90f7,	/*  */
	0xb3d6, 0x90fd,	/*  */
	0xb3d7, 0x9141,	/*  */
	0xb3d8, 0x9142,	/*  */
	0xb3d9, 0x9145,	/*  */
	0xb3da, 0x9149,	/*  */
	0xb3db, 0x9151,	/*  */
	0xb3dc, 0x9153,	/*  */
	0xb3dd, 0x9155,	/*  */
	0xb3de, 0x9156,	/*  */
	0xb3df, 0x9157,	/*  */
	0xb3e0, 0x9161,	/*  */
	0xb3e1, 0x9162,	/*  */
	0xb3e2, 0x9165,	/*  */
	0xb3e3, 0x9169,	/*  */
	0xb3e4, 0x9171,	/*  */
	0xb3e5, 0x9173,	/*  */
	0xb3e6, 0x9176,	/*  */
	0xb3e7, 0x9177,	/*  */
	0xb3e8, 0x917a,	/*  */
	0xb3e9, 0x9181,	/*  */
	0xb3ea, 0x9185,	/*  */
	0xb3eb, 0x91a1,	/*  */
	0xb3ec, 0x91a2,	/*  */
	0xb3ed, 0x91a5,	/*  */
	0xb3ee, 0x91a9,	/*  */
	0xb3ef, 0x91ab,	/*  */
	0xb3f0, 0x91b1,	/*  */
	0xb3f1, 0x91b3,	/*  */
	0xb3f2, 0x91b5,	/*  */
	0xb3f3, 0x91b7,	/*  */
	0xb3f4, 0x91bc,	/*  */
	0xb3f5, 0x91bd,	/*  */
	0xb3f6, 0x91c1,	/*  */
	0xb3f7, 0x91c5,	/*  */
	0xb3f8, 0x91c9,	/*  */
	0xb3f9, 0x91d6,	/*  */
	0xb3fa, 0x9241,	/*  */
	0xb3fb, 0x9245,	/*  */
	0xb3fc, 0x9249,	/*  */
	0xb3fd, 0x9251,	/*  */
	0xb3fe, 0x9253,	/*  */
	0xb4a1, 0x9255,	/*  */
	0xb4a2, 0x9261,	/*  */
	0xb4a3, 0x9262,	/*  */
	0xb4a4, 0x9265,	/*  */
	0xb4a5, 0x9269,	/*  */
	0xb4a6, 0x9273,	/*  */
	0xb4a7, 0x9275,	/*  */
	0xb4a8, 0x9277,	/*  */
	0xb4a9, 0x9281,	/*  */
	0xb4aa, 0x9282,	/*  */
	0xb4ab, 0x9285,	/*  */
	0xb4ac, 0x9288,	/*  */
	0xb4ad, 0x9289,	/*  */
	0xb4ae, 0x9291,	/*  */
	0xb4af, 0x9293,	/*  */
	0xb4b0, 0x9295,	/*  */
	0xb4b1, 0x9297,	/*  */
	0xb4b2, 0x92a1,	/*  */
	0xb4b3, 0x92b6,	/*  */
	0xb4b4, 0x92c1,	/*  */
	0xb4b5, 0x92e1,	/*  */
	0xb4b6, 0x92e5,	/*  */
	0xb4b7, 0x92e9,	/*  */
	0xb4b8, 0x92f1,	/*  */
	0xb4b9, 0x92f3,	/*  */
	0xb4ba, 0x9341,	/*  */
	0xb4bb, 0x9342,	/*  */
	0xb4bc, 0x9349,	/*  */
	0xb4bd, 0x9351,	/*  */
	0xb4be, 0x9353,	/*  */
	0xb4bf, 0x9357,	/*  */
	0xb4c0, 0x9361,	/*  */
	0xb4c1, 0x9362,	/*  */
	0xb4c2, 0x9365,	/*  */
	0xb4c3, 0x9369,	/*  */
	0xb4c4, 0x936a,	/*  */
	0xb4c5, 0x936b,	/*  */
	0xb4c6, 0x9371,	/*  */
	0xb4c7, 0x9373,	/*  */
	0xb4c8, 0x9375,	/*  */
	0xb4c9, 0x9377,	/*  */
	0xb4ca, 0x9378,	/*  */
	0xb4cb, 0x937c,	/*  */
	0xb4cc, 0x9381,	/*  */
	0xb4cd, 0x9385,	/*  */
	0xb4ce, 0x9389,	/*  */
	0xb4cf, 0x93a1,	/*  */
	0xb4d0, 0x93a2,	/*  */
	0xb4d1, 0x93a5,	/*  */
	0xb4d2, 0x93a9,	/*  */
	0xb4d3, 0x93ab,	/*  */
	0xb4d4, 0x93b1,	/*  */
	0xb4d5, 0x93b3,	/*  */
	0xb4d6, 0x93b5,	/*  */
	0xb4d7, 0x93b7,	/*  */
	0xb4d8, 0x93bc,	/*  */
	0xb4d9, 0x9461,	/*  */
	0xb4da, 0x9462,	/*  */
	0xb4db, 0x9463,	/*  */
	0xb4dc, 0x9465,	/*  */
	0xb4dd, 0x9468,	/*  */
	0xb4de, 0x9469,	/*  */
	0xb4df, 0x946a,	/*  */
	0xb4e0, 0x946b,	/*  */
	0xb4e1, 0x946c,	/*  */
	0xb4e2, 0x9470,	/*  */
	0xb4e3, 0x9471,	/*  */
	0xb4e4, 0x9473,	/*  */
	0xb4e5, 0x9475,	/*  */
	0xb4e6, 0x9476,	/*  */
	0xb4e7, 0x9477,	/*  */
	0xb4e8, 0x9478,	/*  */
	0xb4e9, 0x9479,	/*  */
	0xb4ea, 0x947d,	/*  */
	0xb4eb, 0x9481,	/*  */
	0xb4ec, 0x9482,	/*  */
	0xb4ed, 0x9485,	/*  */
	0xb4ee, 0x9489,	/*  */
	0xb4ef, 0x9491,	/*  */
	0xb4f0, 0x9493,	/*  */
	0xb4f1, 0x9495,	/*  */
	0xb4f2, 0x9496,	/*  */
	0xb4f3, 0x9497,	/*  */
	0xb4f4, 0x94a1,	/*  */
	0xb4f5, 0x94e1,	/*  */
	0xb4f6, 0x94e2,	/*  */
	0xb4f7, 0x94e3,	/*  */
	0xb4f8, 0x94e5,	/*  */
	0xb4f9, 0x94e8,	/*  */
	0xb4fa, 0x94e9,	/*  */
	0xb4fb, 0x94eb,	/*  */
	0xb4fc, 0x94ec,	/*  */
	0xb4fd, 0x94f1,	/*  */
	0xb4fe, 0x94f3,	/*  */
	0xb5a1, 0x94f5,	/*  */
	0xb5a2, 0x94f7,	/*  */
	0xb5a3, 0x94f9,	/*  */
	0xb5a4, 0x94fc,	/*  */
	0xb5a5, 0x9541,	/*  */
	0xb5a6, 0x9542,	/*  */
	0xb5a7, 0x9545,	/*  */
	0xb5a8, 0x9549,	/*  */
	0xb5a9, 0x9551,	/*  */
	0xb5aa, 0x9553,	/*  */
	0xb5ab, 0x9555,	/*  */
	0xb5ac, 0x9556,	/*  */
	0xb5ad, 0x9557,	/*  */
	0xb5ae, 0x9561,	/*  */
	0xb5af, 0x9565,	/*  */
	0xb5b0, 0x9569,	/*  */
	0xb5b1, 0x9576,	/*  */
	0xb5b2, 0x9577,	/*  */
	0xb5b3, 0x9581,	/*  */
	0xb5b4, 0x9585,	/*  */
	0xb5b5, 0x95a1,	/*  */
	0xb5b6, 0x95a2,	/*  */
	0xb5b7, 0x95a5,	/*  */
	0xb5b8, 0x95a8,	/*  */
	0xb5b9, 0x95a9,	/*  */
	0xb5ba, 0x95ab,	/*  */
	0xb5bb, 0x95ad,	/*  */
	0xb5bc, 0x95b1,	/*  */
	0xb5bd, 0x95b3,	/*  */
	0xb5be, 0x95b5,	/*  */
	0xb5bf, 0x95b7,	/*  */
	0xb5c0, 0x95b9,	/*  */
	0xb5c1, 0x95bb,	/*  */
	0xb5c2, 0x95c1,	/*  */
	0xb5c3, 0x95c5,	/*  */
	0xb5c4, 0x95c9,	/*  */
	0xb5c5, 0x95e1,	/*  */
	0xb5c6, 0x95f6,	/*  */
	0xb5c7, 0x9641,	/*  */
	0xb5c8, 0x9645,	/*  */
	0xb5c9, 0x9649,	/*  */
	0xb5ca, 0x9651,	/*  */
	0xb5cb, 0x9653,	/*  */
	0xb5cc, 0x9655,	/*  */
	0xb5cd, 0x9661,	/*  */
	0xb5ce, 0x9681,	/*  */
	0xb5cf, 0x9682,	/*  */
	0xb5d0, 0x9685,	/*  */
	0xb5d1, 0x9689,	/*  */
	0xb5d2, 0x9691,	/*  */
	0xb5d3, 0x9693,	/*  */
	0xb5d4, 0x9695,	/*  */
	0xb5d5, 0x9697,	/*  */
	0xb5d6, 0x96a1,	/*  */
	0xb5d7, 0x96b6,	/*  */
	0xb5d8, 0x96c1,	/*  */
	0xb5d9, 0x96d7,	/*  */
	0xb5da, 0x96e1,	/*  */
	0xb5db, 0x96e5,	/*  */
	0xb5dc, 0x96e9,	/*  */
	0xb5dd, 0x96f3,	/*  */
	0xb5de, 0x96f5,	/*  */
	0xb5df, 0x96f7,	/*  */
	0xb5e0, 0x9741,	/*  */
	0xb5e1, 0x9745,	/*  */
	0xb5e2, 0x9749,	/*  */
	0xb5e3, 0x9751,	/*  */
	0xb5e4, 0x9757,	/*  */
	0xb5e5, 0x9761,	/*  */
	0xb5e6, 0x9762,	/*  */
	0xb5e7, 0x9765,	/*  */
	0xb5e8, 0x9768,	/*  */
	0xb5e9, 0x9769,	/*  */
	0xb5ea, 0x976b,	/*  */
	0xb5eb, 0x9771,	/*  */
	0xb5ec, 0x9773,	/*  */
	0xb5ed, 0x9775,	/*  */
	0xb5ee, 0x9777,	/*  */
	0xb5ef, 0x9781,	/*  */
	0xb5f0, 0x97a1,	/*  */
	0xb5f1, 0x97a2,	/*  */
	0xb5f2, 0x97a5,	/*  */
	0xb5f3, 0x97a8,	/*  */
	0xb5f4, 0x97a9,	/*  */
	0xb5f5, 0x97b1,	/*  */
	0xb5f6, 0x97b3,	/*  */
	0xb5f7, 0x97b5,	/*  */
	0xb5f8, 0x97b6,	/*  */
	0xb5f9, 0x97b7,	/*  */
	0xb5fa, 0x97b8,	/*  */
	0xb5fb, 0x9861,	/*  */
	0xb5fc, 0x9862,	/*  */
	0xb5fd, 0x9865,	/*  */
	0xb5fe, 0x9869,	/*  */
	0xb6a1, 0x9871,	/*  */
	0xb6a2, 0x9873,	/*  */
	0xb6a3, 0x9875,	/*  */
	0xb6a4, 0x9876,	/*  */
	0xb6a5, 0x9877,	/*  */
	0xb6a6, 0x987d,	/*  */
	0xb6a7, 0x9881,	/*  */
	0xb6a8, 0x9882,	/*  */
	0xb6a9, 0x9885,	/*  */
	0xb6aa, 0x9889,	/*  */
	0xb6ab, 0x9891,	/*  */
	0xb6ac, 0x9893,	/*  */
	0xb6ad, 0x9895,	/*  */
	0xb6ae, 0x9896,	/*  */
	0xb6af, 0x9897,	/*  */
	0xb6b0, 0x98e1,	/*  */
	0xb6b1, 0x98e2,	/*  */
	0xb6b2, 0x98e5,	/*  */
	0xb6b3, 0x98e9,	/*  */
	0xb6b4, 0x98eb,	/*  */
	0xb6b5, 0x98ec,	/*  */
	0xb6b6, 0x98f1,	/*  */
	0xb6b7, 0x98f3,	/*  */
	0xb6b8, 0x98f5,	/*  */
	0xb6b9, 0x98f6,	/*  */
	0xb6ba, 0x98f7,	/*  */
	0xb6bb, 0x98fd,	/*  */
	0xb6bc, 0x9941,	/*  */
	0xb6bd, 0x9942,	/*  */
	0xb6be, 0x9945,	/*  */
	0xb6bf, 0x9949,	/*  */
	0xb6c0, 0x9951,	/*  */
	0xb6c1, 0x9953,	/*  */
	0xb6c2, 0x9955,	/*  */
	0xb6c3, 0x9956,	/*  */
	0xb6c4, 0x9957,	/*  */
	0xb6c5, 0x9961,	/*  */
	0xb6c6, 0x9976,	/*  */
	0xb6c7, 0x99a1,	/*  */
	0xb6c8, 0x99a2,	/*  */
	0xb6c9, 0x99a5,	/*  */
	0xb6ca, 0x99a9,	/*  */
	0xb6cb, 0x99b7,	/*  */
	0xb6cc, 0x99c1,	/*  */
	0xb6cd, 0x99c9,	/*  */
	0xb6ce, 0x99e1,	/*  */
	0xb6cf, 0x9a41,	/*  */
	0xb6d0, 0x9a45,	/*  */
	0xb6d1, 0x9a81,	/*  */
	0xb6d2, 0x9a82,	/*  */
	0xb6d3, 0x9a85,	/*  */
	0xb6d4, 0x9a89,	/*  */
	0xb6d5, 0x9a90,	/*  */
	0xb6d6, 0x9a91,	/*  */
	0xb6d7, 0x9a97,	/*  */
	0xb6d8, 0x9ac1,	/*  */
	0xb6d9, 0x9ae1,	/*  */
	0xb6da, 0x9ae5,	/*  */
	0xb6db, 0x9ae9,	/*  */
	0xb6dc, 0x9af1,	/*  */
	0xb6dd, 0x9af3,	/*  */
	0xb6de, 0x9af7,	/*  */
	0xb6df, 0x9b61,	/*  */
	0xb6e0, 0x9b62,	/*  */
	0xb6e1, 0x9b65,	/*  */
	0xb6e2, 0x9b68,	/*  */
	0xb6e3, 0x9b69,	/*  */
	0xb6e4, 0x9b71,	/*  */
	0xb6e5, 0x9b73,	/*  */
	0xb6e6, 0x9b75,	/*  */
	0xb6e7, 0x9b81,	/*  */
	0xb6e8, 0x9b85,	/*  */
	0xb6e9, 0x9b89,	/*  */
	0xb6ea, 0x9b91,	/*  */
	0xb6eb, 0x9b93,	/*  */
	0xb6ec, 0x9ba1,	/*  */
	0xb6ed, 0x9ba5,	/*  */
	0xb6ee, 0x9ba9,	/*  */
	0xb6ef, 0x9bb1,	/*  */
	0xb6f0, 0x9bb3,	/*  */
	0xb6f1, 0x9bb5,	/*  */
	0xb6f2, 0x9bb7,	/*  */
	0xb6f3, 0x9c61,	/*  */
	0xb6f4, 0x9c62,	/*  */
	0xb6f5, 0x9c65,	/*  */
	0xb6f6, 0x9c69,	/*  */
	0xb6f7, 0x9c71,	/*  */
	0xb6f8, 0x9c73,	/*  */
	0xb6f9, 0x9c75,	/*  */
	0xb6fa, 0x9c76,	/*  */
	0xb6fb, 0x9c77,	/*  */
	0xb6fc, 0x9c78,	/*  */
	0xb6fd, 0x9c7c,	/*  */
	0xb6fe, 0x9c7d,	/*  */
	0xb7a1, 0x9c81,	/*  */
	0xb7a2, 0x9c82,	/*  */
	0xb7a3, 0x9c85,	/*  */
	0xb7a4, 0x9c89,	/*  */
	0xb7a5, 0x9c91,	/*  */
	0xb7a6, 0x9c93,	/*  */
	0xb7a7, 0x9c95,	/*  */
	0xb7a8, 0x9c96,	/*  */
	0xb7a9, 0x9c97,	/*  */
	0xb7aa, 0x9ca1,	/*  */
	0xb7ab, 0x9ca2,	/*  */
	0xb7ac, 0x9ca5,	/*  */
	0xb7ad, 0x9cb5,	/*  */
	0xb7ae, 0x9cb7,	/*  */
	0xb7af, 0x9ce1,	/*  */
	0xb7b0, 0x9ce2,	/*  */
	0xb7b1, 0x9ce5,	/*  */
	0xb7b2, 0x9ce9,	/*  */
	0xb7b3, 0x9cf1,	/*  */
	0xb7b4, 0x9cf3,	/*  */
	0xb7b5, 0x9cf5,	/*  */
	0xb7b6, 0x9cf6,	/*  */
	0xb7b7, 0x9cf7,	/*  */
	0xb7b8, 0x9cfd,	/*  */
	0xb7b9, 0x9d41,	/*  */
	0xb7ba, 0x9d42,	/*  */
	0xb7bb, 0x9d45,	/*  */
	0xb7bc, 0x9d49,	/*  */
	0xb7bd, 0x9d51,	/*  */
	0xb7be, 0x9d53,	/*  */
	0xb7bf, 0x9d55,	/*  */
	0xb7c0, 0x9d57,	/*  */
	0xb7c1, 0x9d61,	/*  */
	0xb7c2, 0x9d62,	/*  */
	0xb7c3, 0x9d65,	/*  */
	0xb7c4, 0x9d69,	/*  */
	0xb7c5, 0x9d71,	/*  */
	0xb7c6, 0x9d73,	/*  */
	0xb7c7, 0x9d75,	/*  */
	0xb7c8, 0x9d76,	/*  */
	0xb7c9, 0x9d77,	/*  */
	0xb7ca, 0x9d81,	/*  */
	0xb7cb, 0x9d85,	/*  */
	0xb7cc, 0x9d93,	/*  */
	0xb7cd, 0x9d95,	/*  */
	0xb7ce, 0x9da1,	/*  */
	0xb7cf, 0x9da2,	/*  */
	0xb7d0, 0x9da5,	/*  */
	0xb7d1, 0x9da9,	/*  */
	0xb7d2, 0x9db1,	/*  */
	0xb7d3, 0x9db3,	/*  */
	0xb7d4, 0x9db5,	/*  */
	0xb7d5, 0x9db7,	/*  */
	0xb7d6, 0x9dc1,	/*  */
	0xb7d7, 0x9dc5,	/*  */
	0xb7d8, 0x9dd7,	/*  */
	0xb7d9, 0x9df6,	/*  */
	0xb7da, 0x9e41,	/*  */
	0xb7db, 0x9e45,	/*  */
	0xb7dc, 0x9e49,	/*  */
	0xb7dd, 0x9e51,	/*  */
	0xb7de, 0x9e53,	/*  */
	0xb7df, 0x9e55,	/*  */
	0xb7e0, 0x9e57,	/*  */
	0xb7e1, 0x9e61,	/*  */
	0xb7e2, 0x9e65,	/*  */
	0xb7e3, 0x9e69,	/*  */
	0xb7e4, 0x9e73,	/*  */
	0xb7e5, 0x9e75,	/*  */
	0xb7e6, 0x9e77,	/*  */
	0xb7e7, 0x9e81,	/*  */
	0xb7e8, 0x9e82,	/*  */
	0xb7e9, 0x9e85,	/*  */
	0xb7ea, 0x9e89,	/*  */
	0xb7eb, 0x9e91,	/*  */
	0xb7ec, 0x9e93,	/*  */
	0xb7ed, 0x9e95,	/*  */
	0xb7ee, 0x9e97,	/*  */
	0xb7ef, 0x9ea1,	/*  */
	0xb7f0, 0x9eb6,	/*  */
	0xb7f1, 0x9ec1,	/*  */
	0xb7f2, 0x9ee1,	/*  */
	0xb7f3, 0x9ee2,	/*  */
	0xb7f4, 0x9ee5,	/*  */
	0xb7f5, 0x9ee9,	/*  */
	0xb7f6, 0x9ef1,	/*  */
	0xb7f7, 0x9ef5,	/*  */
	0xb7f8, 0x9ef7,	/*  */
	0xb7f9, 0x9f41,	/*  */
	0xb7fa, 0x9f42,	/*  */
	0xb7fb, 0x9f45,	/*  */
	0xb7fc, 0x9f49,	/*  */
	0xb7fd, 0x9f51,	/*  */
	0xb7fe, 0x9f53,	/*  */
	0xb8a1, 0x9f55,	/*  */
	0xb8a2, 0x9f57,	/*  */
	0xb8a3, 0x9f61,	/*  */
	0xb8a4, 0x9f62,	/*  */
	0xb8a5, 0x9f65,	/*  */
	0xb8a6, 0x9f69,	/*  */
	0xb8a7, 0x9f71,	/*  */
	0xb8a8, 0x9f73,	/*  */
	0xb8a9, 0x9f75,	/*  */
	0xb8aa, 0x9f77,	/*  */
	0xb8ab, 0x9f78,	/*  */
	0xb8ac, 0x9f7b,	/*  */
	0xb8ad, 0x9f7c,	/*  */
	0xb8ae, 0x9fa1,	/*  */
	0xb8af, 0x9fa2,	/*  */
	0xb8b0, 0x9fa5,	/*  */
	0xb8b1, 0x9fa9,	/*  */
	0xb8b2, 0x9fb1,	/*  */
	0xb8b3, 0x9fb3,	/*  */
	0xb8b4, 0x9fb5,	/*  */
	0xb8b5, 0x9fb7,	/*  */
	0xb8b6, 0xa061,	/*  */
	0xb8b7, 0xa062,	/*  */
	0xb8b8, 0xa065,	/*  */
	0xb8b9, 0xa067,	/*  */
	0xb8ba, 0xa068,	/*  */
	0xb8bb, 0xa069,	/*  */
	0xb8bc, 0xa06a,	/*  */
	0xb8bd, 0xa06b,	/*  */
	0xb8be, 0xa071,	/*  */
	0xb8bf, 0xa073,	/*  */
	0xb8c0, 0xa075,	/*  */
	0xb8c1, 0xa077,	/*  */
	0xb8c2, 0xa078,	/*  */
	0xb8c3, 0xa07b,	/*  */
	0xb8c4, 0xa07d,	/*  */
	0xb8c5, 0xa081,	/*  */
	0xb8c6, 0xa082,	/*  */
	0xb8c7, 0xa085,	/*  */
	0xb8c8, 0xa089,	/*  */
	0xb8c9, 0xa091,	/*  */
	0xb8ca, 0xa093,	/*  */
	0xb8cb, 0xa095,	/*  */
	0xb8cc, 0xa096,	/*  */
	0xb8cd, 0xa097,	/*  */
	0xb8ce, 0xa098,	/*  */
	0xb8cf, 0xa0a1,	/*  */
	0xb8d0, 0xa0a2,	/*  */
	0xb8d1, 0xa0a9,	/*  */
	0xb8d2, 0xa0b7,	/*  */
	0xb8d3, 0xa0e1,	/*  */
	0xb8d4, 0xa0e2,	/*  */
	0xb8d5, 0xa0e5,	/*  */
	0xb8d6, 0xa0e9,	/*  */
	0xb8d7, 0xa0eb,	/*  */
	0xb8d8, 0xa0f1,	/*  */
	0xb8d9, 0xa0f3,	/*  */
	0xb8da, 0xa0f5,	/*  */
	0xb8db, 0xa0f7,	/*  */
	0xb8dc, 0xa0f8,	/*  */
	0xb8dd, 0xa0fd,	/*  */
	0xb8de, 0xa141,	/*  */
	0xb8df, 0xa142,	/*  */
	0xb8e0, 0xa145,	/*  */
	0xb8e1, 0xa149,	/*  */
	0xb8e2, 0xa151,	/*  */
	0xb8e3, 0xa153,	/*  */
	0xb8e4, 0xa155,	/*  */
	0xb8e5, 0xa156,	/*  */
	0xb8e6, 0xa157,	/*  */
	0xb8e7, 0xa161,	/*  */
	0xb8e8, 0xa162,	/*  */
	0xb8e9, 0xa165,	/*  */
	0xb8ea, 0xa169,	/*  */
	0xb8eb, 0xa175,	/*  */
	0xb8ec, 0xa176,	/*  */
	0xb8ed, 0xa177,	/*  */
	0xb8ee, 0xa179,	/*  */
	0xb8ef, 0xa181,	/*  */
	0xb8f0, 0xa1a1,	/*  */
	0xb8f1, 0xa1a2,	/*  */
	0xb8f2, 0xa1a4,	/*  */
	0xb8f3, 0xa1a5,	/*  */
	0xb8f4, 0xa1a9,	/*  */
	0xb8f5, 0xa1ab,	/*  */
	0xb8f6, 0xa1b1,	/*  */
	0xb8f7, 0xa1b3,	/*  */
	0xb8f8, 0xa1b5,	/*  */
	0xb8f9, 0xa1b7,	/*  */
	0xb8fa, 0xa1c1,	/*  */
	0xb8fb, 0xa1c5,	/*  */
	0xb8fc, 0xa1d6,	/*  */
	0xb8fd, 0xa1d7,	/*  */
	0xb8fe, 0xa241,	/*  */
	0xb9a1, 0xa245,	/*  */
	0xb9a2, 0xa249,	/*  */
	0xb9a3, 0xa253,	/*  */
	0xb9a4, 0xa255,	/*  */
	0xb9a5, 0xa257,	/*  */
	0xb9a6, 0xa261,	/*  */
	0xb9a7, 0xa265,	/*  */
	0xb9a8, 0xa269,	/*  */
	0xb9a9, 0xa273,	/*  */
	0xb9aa, 0xa275,	/*  */
	0xb9ab, 0xa281,	/*  */
	0xb9ac, 0xa282,	/*  */
	0xb9ad, 0xa283,	/*  */
	0xb9ae, 0xa285,	/*  */
	0xb9af, 0xa288,	/*  */
	0xb9b0, 0xa289,	/*  */
	0xb9b1, 0xa28a,	/*  */
	0xb9b2, 0xa28b,	/*  */
	0xb9b3, 0xa291,	/*  */
	0xb9b4, 0xa293,	/*  */
	0xb9b5, 0xa295,	/*  */
	0xb9b6, 0xa297,	/*  */
	0xb9b7, 0xa29b,	/*  */
	0xb9b8, 0xa29d,	/*  */
	0xb9b9, 0xa2a1,	/*  */
	0xb9ba, 0xa2a5,	/*  */
	0xb9bb, 0xa2a9,	/*  */
	0xb9bc, 0xa2b3,	/*  */
	0xb9bd, 0xa2b5,	/*  */
	0xb9be, 0xa2c1,	/*  */
	0xb9bf, 0xa2e1,	/*  */
	0xb9c0, 0xa2e5,	/*  */
	0xb9c1, 0xa2e9,	/*  */
	0xb9c2, 0xa341,	/*  */
	0xb9c3, 0xa345,	/*  */
	0xb9c4, 0xa349,	/*  */
	0xb9c5, 0xa351,	/*  */
	0xb9c6, 0xa355,	/*  */
	0xb9c7, 0xa361,	/*  */
	0xb9c8, 0xa365,	/*  */
	0xb9c9, 0xa369,	/*  */
	0xb9ca, 0xa371,	/*  */
	0xb9cb, 0xa375,	/*  */
	0xb9cc, 0xa3a1,	/*  */
	0xb9cd, 0xa3a2,	/*  */
	0xb9ce, 0xa3a5,	/*  */
	0xb9cf, 0xa3a8,	/*  */
	0xb9d0, 0xa3a9,	/*  */
	0xb9d1, 0xa3ab,	/*  */
	0xb9d2, 0xa3b1,	/*  */
	0xb9d3, 0xa3b3,	/*  */
	0xb9d4, 0xa3b5,	/*  */
	0xb9d5, 0xa3b6,	/*  */
	0xb9d6, 0xa3b7,	/*  */
	0xb9d7, 0xa3b9,	/*  */
	0xb9d8, 0xa3bb,	/*  */
	0xb9d9, 0xa461,	/*  */
	0xb9da, 0xa462,	/*  */
	0xb9db, 0xa463,	/*  */
	0xb9dc, 0xa464,	/*  */
	0xb9dd, 0xa465,	/*  */
	0xb9de, 0xa468,	/*  */
	0xb9df, 0xa469,	/*  */
	0xb9e0, 0xa46a,	/*  */
	0xb9e1, 0xa46b,	/*  */
	0xb9e2, 0xa46c,	/*  */
	0xb9e3, 0xa471,	/*  */
	0xb9e4, 0xa473,	/*  */
	0xb9e5, 0xa475,	/*  */
	0xb9e6, 0xa477,	/*  */
	0xb9e7, 0xa47b,	/*  */
	0xb9e8, 0xa481,	/*  */
	0xb9e9, 0xa482,	/*  */
	0xb9ea, 0xa485,	/*  */
	0xb9eb, 0xa489,	/*  */
	0xb9ec, 0xa491,	/*  */
	0xb9ed, 0xa493,	/*  */
	0xb9ee, 0xa495,	/*  */
	0xb9ef, 0xa496,	/*  */
	0xb9f0, 0xa497,	/*  */
	0xb9f1, 0xa49b,	/*  */
	0xb9f2, 0xa4a1,	/*  */
	0xb9f3, 0xa4a2,	/*  */
	0xb9f4, 0xa4a5,	/*  */
	0xb9f5, 0xa4b3,	/*  */
	0xb9f6, 0xa4e1,	/*  */
	0xb9f7, 0xa4e2,	/*  */
	0xb9f8, 0xa4e5,	/*  */
	0xb9f9, 0xa4e8,	/*  */
	0xb9fa, 0xa4e9,	/*  */
	0xb9fb, 0xa4eb,	/*  */
	0xb9fc, 0xa4f1,	/*  */
	0xb9fd, 0xa4f3,	/*  */
	0xb9fe, 0xa4f5,	/*  */
	0xbaa1, 0xa4f7,	/*  */
	0xbaa2, 0xa4f8,	/*  */
	0xbaa3, 0xa541,	/*  */
	0xbaa4, 0xa542,	/*  */
	0xbaa5, 0xa545,	/*  */
	0xbaa6, 0xa548,	/*  */
	0xbaa7, 0xa549,	/*  */
	0xbaa8, 0xa551,	/*  */
	0xbaa9, 0xa553,	/*  */
	0xbaaa, 0xa555,	/*  */
	0xbaab, 0xa556,	/*  */
	0xbaac, 0xa557,	/*  */
	0xbaad, 0xa561,	/*  */
	0xbaae, 0xa562,	/*  */
	0xbaaf, 0xa565,	/*  */
	0xbab0, 0xa569,	/*  */
	0xbab1, 0xa573,	/*  */
	0xbab2, 0xa575,	/*  */
	0xbab3, 0xa576,	/*  */
	0xbab4, 0xa577,	/*  */
	0xbab5, 0xa57b,	/*  */
	0xbab6, 0xa581,	/*  */
	0xbab7, 0xa585,	/*  */
	0xbab8, 0xa5a1,	/*  */
	0xbab9, 0xa5a2,	/*  */
	0xbaba, 0xa5a3,	/*  */
	0xbabb, 0xa5a5,	/*  */
	0xbabc, 0xa5a9,	/*  */
	0xbabd, 0xa5b1,	/*  */
	0xbabe, 0xa5b3,	/*  */
	0xbabf, 0xa5b5,	/*  */
	0xbac0, 0xa5b7,	/*  */
	0xbac1, 0xa5c1,	/*  */
	0xbac2, 0xa5c5,	/*  */
	0xbac3, 0xa5d6,	/*  */
	0xbac4, 0xa5e1,	/*  */
	0xbac5, 0xa5f6,	/*  */
	0xbac6, 0xa641,	/*  */
	0xbac7, 0xa642,	/*  */
	0xbac8, 0xa645,	/*  */
	0xbac9, 0xa649,	/*  */
	0xbaca, 0xa651,	/*  */
	0xbacb, 0xa653,	/*  */
	0xbacc, 0xa661,	/*  */
	0xbacd, 0xa665,	/*  */
	0xbace, 0xa681,	/*  */
	0xbacf, 0xa682,	/*  */
	0xbad0, 0xa685,	/*  */
	0xbad1, 0xa688,	/*  */
	0xbad2, 0xa689,	/*  */
	0xbad3, 0xa68a,	/*  */
	0xbad4, 0xa68b,	/*  */
	0xbad5, 0xa691,	/*  */
	0xbad6, 0xa693,	/*  */
	0xbad7, 0xa695,	/*  */
	0xbad8, 0xa697,	/*  */
	0xbad9, 0xa69b,	/*  */
	0xbada, 0xa69c,	/*  */
	0xbadb, 0xa6a1,	/*  */
	0xbadc, 0xa6a9,	/*  */
	0xbadd, 0xa6b6,	/*  */
	0xbade, 0xa6c1,	/*  */
	0xbadf, 0xa6e1,	/*  */
	0xbae0, 0xa6e2,	/*  */
	0xbae1, 0xa6e5,	/*  */
	0xbae2, 0xa6e9,	/*  */
	0xbae3, 0xa6f7,	/*  */
	0xbae4, 0xa741,	/*  */
	0xbae5, 0xa745,	/*  */
	0xbae6, 0xa749,	/*  */
	0xbae7, 0xa751,	/*  */
	0xbae8, 0xa755,	/*  */
	0xbae9, 0xa757,	/*  */
	0xbaea, 0xa761,	/*  */
	0xbaeb, 0xa762,	/*  */
	0xbaec, 0xa765,	/*  */
	0xbaed, 0xa769,	/*  */
	0xbaee, 0xa771,	/*  */
	0xbaef, 0xa773,	/*  */
	0xbaf0, 0xa775,	/*  */
	0xbaf1, 0xa7a1,	/*  */
	0xbaf2, 0xa7a2,	/*  */
	0xbaf3, 0xa7a5,	/*  */
	0xbaf4, 0xa7a9,	/*  */
	0xbaf5, 0xa7ab,	/*  */
	0xbaf6, 0xa7b1,	/*  */
	0xbaf7, 0xa7b3,	/*  */
	0xbaf8, 0xa7b5,	/*  */
	0xbaf9, 0xa7b7,	/*  */
	0xbafa, 0xa7b8,	/*  */
	0xbafb, 0xa7b9,	/*  */
	0xbafc, 0xa861,	/*  */
	0xbafd, 0xa862,	/*  */
	0xbafe, 0xa865,	/*  */
	0xbba1, 0xa869,	/*  */
	0xbba2, 0xa86b,	/*  */
	0xbba3, 0xa871,	/*  */
	0xbba4, 0xa873,	/*  */
	0xbba5, 0xa875,	/*  */
	0xbba6, 0xa876,	/*  */
	0xbba7, 0xa877,	/*  */
	0xbba8, 0xa87d,	/*  */
	0xbba9, 0xa881,	/*  */
	0xbbaa, 0xa882,	/*  */
	0xbbab, 0xa885,	/*  */
	0xbbac, 0xa889,	/*  */
	0xbbad, 0xa891,	/*  */
	0xbbae, 0xa893,	/*  */
	0xbbaf, 0xa895,	/*  */
	0xbbb0, 0xa896,	/*  */
	0xbbb1, 0xa897,	/*  */
	0xbbb2, 0xa8a1,	/*  */
	0xbbb3, 0xa8a2,	/*  */
	0xbbb4, 0xa8b1,	/*  */
	0xbbb5, 0xa8e1,	/*  */
	0xbbb6, 0xa8e2,	/*  */
	0xbbb7, 0xa8e5,	/*  */
	0xbbb8, 0xa8e8,	/*  */
	0xbbb9, 0xa8e9,	/*  */
	0xbbba, 0xa8f1,	/*  */
	0xbbbb, 0xa8f5,	/*  */
	0xbbbc, 0xa8f6,	/*  */
	0xbbbd, 0xa8f7,	/*  */
	0xbbbe, 0xa941,	/*  */
	0xbbbf, 0xa957,	/*  */
	0xbbc0, 0xa961,	/*  */
	0xbbc1, 0xa962,	/*  */
	0xbbc2, 0xa971,	/*  */
	0xbbc3, 0xa973,	/*  */
	0xbbc4, 0xa975,	/*  */
	0xbbc5, 0xa976,	/*  */
	0xbbc6, 0xa977,	/*  */
	0xbbc7, 0xa9a1,	/*  */
	0xbbc8, 0xa9a2,	/*  */
	0xbbc9, 0xa9a5,	/*  */
	0xbbca, 0xa9a9,	/*  */
	0xbbcb, 0xa9b1,	/*  */
	0xbbcc, 0xa9b3,	/*  */
	0xbbcd, 0xa9b7,	/*  */
	0xbbce, 0xaa41,	/*  */
	0xbbcf, 0xaa61,	/*  */
	0xbbd0, 0xaa77,	/*  */
	0xbbd1, 0xaa81,	/*  */
	0xbbd2, 0xaa82,	/*  */
	0xbbd3, 0xaa85,	/*  */
	0xbbd4, 0xaa89,	/*  */
	0xbbd5, 0xaa91,	/*  */
	0xbbd6, 0xaa95,	/*  */
	0xbbd7, 0xaa97,	/*  */
	0xbbd8, 0xab41,	/*  */
	0xbbd9, 0xab57,	/*  */
	0xbbda, 0xab61,	/*  */
	0xbbdb, 0xab65,	/*  */
	0xbbdc, 0xab69,	/*  */
	0xbbdd, 0xab71,	/*  */
	0xbbde, 0xab73,	/*  */
	0xbbdf, 0xaba1,	/*  */
	0xbbe0, 0xaba2,	/*  */
	0xbbe1, 0xaba5,	/*  */
	0xbbe2, 0xaba9,	/*  */
	0xbbe3, 0xabb1,	/*  */
	0xbbe4, 0xabb3,	/*  */
	0xbbe5, 0xabb5,	/*  */
	0xbbe6, 0xabb7,	/*  */
	0xbbe7, 0xac61,	/*  */
	0xbbe8, 0xac62,	/*  */
	0xbbe9, 0xac64,	/*  */
	0xbbea, 0xac65,	/*  */
	0xbbeb, 0xac68,	/*  */
	0xbbec, 0xac69,	/*  */
	0xbbed, 0xac6a,	/*  */
	0xbbee, 0xac6b,	/*  */
	0xbbef, 0xac71,	/*  */
	0xbbf0, 0xac73,	/*  */
	0xbbf1, 0xac75,	/*  */
	0xbbf2, 0xac76,	/*  */
	0xbbf3, 0xac77,	/*  */
	0xbbf4, 0xac7b,	/*  */
	0xbbf5, 0xac81,	/*  */
	0xbbf6, 0xac82,	/*  */
	0xbbf7, 0xac85,	/*  */
	0xbbf8, 0xac89,	/*  */
	0xbbf9, 0xac91,	/*  */
	0xbbfa, 0xac93,	/*  */
	0xbbfb, 0xac95,	/*  */
	0xbbfc, 0xac96,	/*  */
	0xbbfd, 0xac97,	/*  */
	0xbbfe, 0xaca1,	/*  */
	0xbca1, 0xaca2,	/*  */
	0xbca2, 0xaca5,	/*  */
	0xbca3, 0xaca9,	/*  */
	0xbca4, 0xacb1,	/*  */
	0xbca5, 0xacb3,	/*  */
	0xbca6, 0xacb5,	/*  */
	0xbca7, 0xacb7,	/*  */
	0xbca8, 0xacc1,	/*  */
	0xbca9, 0xacc5,	/*  */
	0xbcaa, 0xacc9,	/*  */
	0xbcab, 0xacd1,	/*  */
	0xbcac, 0xacd7,	/*  */
	0xbcad, 0xace1,	/*  */
	0xbcae, 0xace2,	/*  */
	0xbcaf, 0xace3,	/*  */
	0xbcb0, 0xace4,	/*  */
	0xbcb1, 0xace5,	/*  */
	0xbcb2, 0xace8,	/*  */
	0xbcb3, 0xace9,	/*  */
	0xbcb4, 0xaceb,	/*  */
	0xbcb5, 0xacec,	/*  */
	0xbcb6, 0xacf1,	/*  */
	0xbcb7, 0xacf3,	/*  */
	0xbcb8, 0xacf5,	/*  */
	0xbcb9, 0xacf6,	/*  */
	0xbcba, 0xacf7,	/*  */
	0xbcbb, 0xacfc,	/*  */
	0xbcbc, 0xad41,	/*  */
	0xbcbd, 0xad42,	/*  */
	0xbcbe, 0xad45,	/*  */
	0xbcbf, 0xad49,	/*  */
	0xbcc0, 0xad51,	/*  */
	0xbcc1, 0xad53,	/*  */
	0xbcc2, 0xad55,	/*  */
	0xbcc3, 0xad56,	/*  */
	0xbcc4, 0xad57,	/*  */
	0xbcc5, 0xad61,	/*  */
	0xbcc6, 0xad62,	/*  */
	0xbcc7, 0xad65,	/*  */
	0xbcc8, 0xad69,	/*  */
	0xbcc9, 0xad71,	/*  */
	0xbcca, 0xad73,	/*  */
	0xbccb, 0xad75,	/*  */
	0xbccc, 0xad76,	/*  */
	0xbccd, 0xad77,	/*  */
	0xbcce, 0xad81,	/*  */
	0xbccf, 0xad85,	/*  */
	0xbcd0, 0xad89,	/*  */
	0xbcd1, 0xad97,	/*  */
	0xbcd2, 0xada1,	/*  */
	0xbcd3, 0xada2,	/*  */
	0xbcd4, 0xada3,	/*  */
	0xbcd5, 0xada5,	/*  */
	0xbcd6, 0xada9,	/*  */
	0xbcd7, 0xadab,	/*  */
	0xbcd8, 0xadb1,	/*  */
	0xbcd9, 0xadb3,	/*  */
	0xbcda, 0xadb5,	/*  */
	0xbcdb, 0xadb7,	/*  */
	0xbcdc, 0xadbb,	/*  */
	0xbcdd, 0xadc1,	/*  */
	0xbcde, 0xadc2,	/*  */
	0xbcdf, 0xadc5,	/*  */
	0xbce0, 0xadc9,	/*  */
	0xbce1, 0xadd7,	/*  */
	0xbce2, 0xade1,	/*  */
	0xbce3, 0xade5,	/*  */
	0xbce4, 0xade9,	/*  */
	0xbce5, 0xadf1,	/*  */
	0xbce6, 0xadf5,	/*  */
	0xbce7, 0xadf6,	/*  */
	0xbce8, 0xae41,	/*  */
	0xbce9, 0xae45,	/*  */
	0xbcea, 0xae49,	/*  */
	0xbceb, 0xae51,	/*  */
	0xbcec, 0xae53,	/*  */
	0xbced, 0xae55,	/*  */
	0xbcee, 0xae61,	/*  */
	0xbcef, 0xae62,	/*  */
	0xbcf0, 0xae65,	/*  */
	0xbcf1, 0xae69,	/*  */
	0xbcf2, 0xae71,	/*  */
	0xbcf3, 0xae73,	/*  */
	0xbcf4, 0xae75,	/*  */
	0xbcf5, 0xae77,	/*  */
	0xbcf6, 0xae81,	/*  */
	0xbcf7, 0xae82,	/*  */
	0xbcf8, 0xae85,	/*  */
	0xbcf9, 0xae88,	/*  */
	0xbcfa, 0xae89,	/*  */
	0xbcfb, 0xae91,	/*  */
	0xbcfc, 0xae93,	/*  */
	0xbcfd, 0xae95,	/*  */
	0xbcfe, 0xae97,	/*  */
	0xbda1, 0xae99,	/*  */
	0xbda2, 0xae9b,	/*  */
	0xbda3, 0xae9c,	/*  */
	0xbda4, 0xaea1,	/*  */
	0xbda5, 0xaeb6,	/*  */
	0xbda6, 0xaec1,	/*  */
	0xbda7, 0xaec2,	/*  */
	0xbda8, 0xaec5,	/*  */
	0xbda9, 0xaec9,	/*  */
	0xbdaa, 0xaed1,	/*  */
	0xbdab, 0xaed7,	/*  */
	0xbdac, 0xaee1,	/*  */
	0xbdad, 0xaee2,	/*  */
	0xbdae, 0xaee5,	/*  */
	0xbdaf, 0xaee9,	/*  */
	0xbdb0, 0xaef1,	/*  */
	0xbdb1, 0xaef3,	/*  */
	0xbdb2, 0xaef5,	/*  */
	0xbdb3, 0xaef7,	/*  */
	0xbdb4, 0xaf41,	/*  */
	0xbdb5, 0xaf42,	/*  */
	0xbdb6, 0xaf49,	/*  */
	0xbdb7, 0xaf51,	/*  */
	0xbdb8, 0xaf55,	/*  */
	0xbdb9, 0xaf57,	/*  */
	0xbdba, 0xaf61,	/*  */
	0xbdbb, 0xaf62,	/*  */
	0xbdbc, 0xaf65,	/*  */
	0xbdbd, 0xaf69,	/*  */
	0xbdbe, 0xaf6a,	/*  */
	0xbdbf, 0xaf71,	/*  */
	0xbdc0, 0xaf73,	/*  */
	0xbdc1, 0xaf75,	/*  */
	0xbdc2, 0xaf77,	/*  */
	0xbdc3, 0xafa1,	/*  */
	0xbdc4, 0xafa2,	/*  */
	0xbdc5, 0xafa5,	/*  */
	0xbdc6, 0xafa8,	/*  */
	0xbdc7, 0xafa9,	/*  */
	0xbdc8, 0xafb0,	/*  */
	0xbdc9, 0xafb1,	/*  */
	0xbdca, 0xafb3,	/*  */
	0xbdcb, 0xafb5,	/*  */
	0xbdcc, 0xafb7,	/*  */
	0xbdcd, 0xafbc,	/*  */
	0xbdce, 0xb061,	/*  */
	0xbdcf, 0xb062,	/*  */
	0xbdd0, 0xb064,	/*  */
	0xbdd1, 0xb065,	/*  */
	0xbdd2, 0xb069,	/*  */
	0xbdd3, 0xb071,	/*  */
	0xbdd4, 0xb073,	/*  */
	0xbdd5, 0xb076,	/*  */
	0xbdd6, 0xb077,	/*  */
	0xbdd7, 0xb07d,	/*  */
	0xbdd8, 0xb081,	/*  */
	0xbdd9, 0xb082,	/*  */
	0xbdda, 0xb085,	/*  */
	0xbddb, 0xb089,	/*  */
	0xbddc, 0xb091,	/*  */
	0xbddd, 0xb093,	/*  */
	0xbdde, 0xb096,	/*  */
	0xbddf, 0xb097,	/*  */
	0xbde0, 0xb0b7,	/*  */
	0xbde1, 0xb0e1,	/*  */
	0xbde2, 0xb0e2,	/*  */
	0xbde3, 0xb0e5,	/*  */
	0xbde4, 0xb0e9,	/*  */
	0xbde5, 0xb0eb,	/*  */
	0xbde6, 0xb0f1,	/*  */
	0xbde7, 0xb0f3,	/*  */
	0xbde8, 0xb0f6,	/*  */
	0xbde9, 0xb0f7,	/*  */
	0xbdea, 0xb141,	/*  */
	0xbdeb, 0xb145,	/*  */
	0xbdec, 0xb149,	/*  */
	0xbded, 0xb185,	/*  */
	0xbdee, 0xb1a1,	/*  */
	0xbdef, 0xb1a2,	/*  */
	0xbdf0, 0xb1a5,	/*  */
	0xbdf1, 0xb1a8,	/*  */
	0xbdf2, 0xb1a9,	/*  */
	0xbdf3, 0xb1ab,	/*  */
	0xbdf4, 0xb1b1,	/*  */
	0xbdf5, 0xb1b3,	/*  */
	0xbdf6, 0xb1b7,	/*  */
	0xbdf7, 0xb1c1,	/*  */
	0xbdf8, 0xb1c2,	/*  */
	0xbdf9, 0xb1c5,	/*  */
	0xbdfa, 0xb1d6,	/*  */
	0xbdfb, 0xb1e1,	/*  */
	0xbdfc, 0xb1f6,	/*  */
	0xbdfd, 0xb241,	/*  */
	0xbdfe, 0xb245,	/*  */
	0xbea1, 0xb249,	/*  */
	0xbea2, 0xb251,	/*  */
	0xbea3, 0xb253,	/*  */
	0xbea4, 0xb261,	/*  */
	0xbea5, 0xb281,	/*  */
	0xbea6, 0xb282,	/*  */
	0xbea7, 0xb285,	/*  */
	0xbea8, 0xb289,	/*  */
	0xbea9, 0xb291,	/*  */
	0xbeaa, 0xb293,	/*  */
	0xbeab, 0xb297,	/*  */
	0xbeac, 0xb2a1,	/*  */
	0xbead, 0xb2b6,	/*  */
	0xbeae, 0xb2c1,	/*  */
	0xbeaf, 0xb2e1,	/*  */
	0xbeb0, 0xb2e5,	/*  */
	0xbeb1, 0xb357,	/*  */
	0xbeb2, 0xb361,	/*  */
	0xbeb3, 0xb362,	/*  */
	0xbeb4, 0xb365,	/*  */
	0xbeb5, 0xb369,	/*  */
	0xbeb6, 0xb36b,	/*  */
	0xbeb7, 0xb370,	/*  */
	0xbeb8, 0xb371,	/*  */
	0xbeb9, 0xb373,	/*  */
	0xbeba, 0xb381,	/*  */
	0xbebb, 0xb385,	/*  */
	0xbebc, 0xb389,	/*  */
	0xbebd, 0xb391,	/*  */
	0xbebe, 0xb3a1,	/*  */
	0xbebf, 0xb3a2,	/*  */
	0xbec0, 0xb3a5,	/*  */
	0xbec1, 0xb3a9,	/*  */
	0xbec2, 0xb3b1,	/*  */
	0xbec3, 0xb3b3,	/*  */
	0xbec4, 0xb3b5,	/*  */
	0xbec5, 0xb3b7,	/*  */
	0xbec6, 0xb461,	/*  */
	0xbec7, 0xb462,	/*  */
	0xbec8, 0xb465,	/*  */
	0xbec9, 0xb466,	/*  */
	0xbeca, 0xb467,	/*  */
	0xbecb, 0xb469,	/*  */
	0xbecc, 0xb46a,	/*  */
	0xbecd, 0xb46b,	/*  */
	0xbece, 0xb470,	/*  */
	0xbecf, 0xb471,	/*  */
	0xbed0, 0xb473,	/*  */
	0xbed1, 0xb475,	/*  */
	0xbed2, 0xb476,	/*  */
	0xbed3, 0xb477,	/*  */
	0xbed4, 0xb47b,	/*  */
	0xbed5, 0xb47c,	/*  */
	0xbed6, 0xb481,	/*  */
	0xbed7, 0xb482,	/*  */
	0xbed8, 0xb485,	/*  */
	0xbed9, 0xb489,	/*  */
	0xbeda, 0xb491,	/*  */
	0xbedb, 0xb493,	/*  */
	0xbedc, 0xb495,	/*  */
	0xbedd, 0xb496,	/*  */
	0xbede, 0xb497,	/*  */
	0xbedf, 0xb4a1,	/*  */
	0xbee0, 0xb4a2,	/*  */
	0xbee1, 0xb4a5,	/*  */
	0xbee2, 0xb4a9,	/*  */
	0xbee3, 0xb4ac,	/*  */
	0xbee4, 0xb4b1,	/*  */
	0xbee5, 0xb4b3,	/*  */
	0xbee6, 0xb4b5,	/*  */
	0xbee7, 0xb4b7,	/*  */
	0xbee8, 0xb4bb,	/*  */
	0xbee9, 0xb4bd,	/*  */
	0xbeea, 0xb4c1,	/*  */
	0xbeeb, 0xb4c5,	/*  */
	0xbeec, 0xb4c9,	/*  */
	0xbeed, 0xb4d3,	/*  */
	0xbeee, 0xb4e1,	/*  */
	0xbeef, 0xb4e2,	/*  */
	0xbef0, 0xb4e5,	/*  */
	0xbef1, 0xb4e6,	/*  */
	0xbef2, 0xb4e8,	/*  */
	0xbef3, 0xb4e9,	/*  */
	0xbef4, 0xb4ea,	/*  */
	0xbef5, 0xb4eb,	/*  */
	0xbef6, 0xb4f1,	/*  */
	0xbef7, 0xb4f3,	/*  */
	0xbef8, 0xb4f4,	/*  */
	0xbef9, 0xb4f5,	/*  */
	0xbefa, 0xb4f6,	/*  */
	0xbefb, 0xb4f7,	/*  */
	0xbefc, 0xb4f8,	/*  */
	0xbefd, 0xb4fa,	/*  */
	0xbefe, 0xb4fc,	/*  */
	0xbfa1, 0xb541,	/*  */
	0xbfa2, 0xb542,	/*  */
	0xbfa3, 0xb545,	/*  */
	0xbfa4, 0xb549,	/*  */
	0xbfa5, 0xb551,	/*  */
	0xbfa6, 0xb553,	/*  */
	0xbfa7, 0xb555,	/*  */
	0xbfa8, 0xb557,	/*  */
	0xbfa9, 0xb561,	/*  */
	0xbfaa, 0xb562,	/*  */
	0xbfab, 0xb563,	/*  */
	0xbfac, 0xb565,	/*  */
	0xbfad, 0xb569,	/*  */
	0xbfae, 0xb56b,	/*  */
	0xbfaf, 0xb56c,	/*  */
	0xbfb0, 0xb571,	/*  */
	0xbfb1, 0xb573,	/*  */
	0xbfb2, 0xb574,	/*  */
	0xbfb3, 0xb575,	/*  */
	0xbfb4, 0xb576,	/*  */
	0xbfb5, 0xb577,	/*  */
	0xbfb6, 0xb57b,	/*  */
	0xbfb7, 0xb57c,	/*  */
	0xbfb8, 0xb57d,	/*  */
	0xbfb9, 0xb581,	/*  */
	0xbfba, 0xb585,	/*  */
	0xbfbb, 0xb589,	/*  */
	0xbfbc, 0xb591,	/*  */
	0xbfbd, 0xb593,	/*  */
	0xbfbe, 0xb595,	/*  */
	0xbfbf, 0xb596,	/*  */
	0xbfc0, 0xb5a1,	/*  */
	0xbfc1, 0xb5a2,	/*  */
	0xbfc2, 0xb5a5,	/*  */
	0xbfc3, 0xb5a9,	/*  */
	0xbfc4, 0xb5aa,	/*  */
	0xbfc5, 0xb5ab,	/*  */
	0xbfc6, 0xb5ad,	/*  */
	0xbfc7, 0xb5b0,	/*  */
	0xbfc8, 0xb5b1,	/*  */
	0xbfc9, 0xb5b3,	/*  */
	0xbfca, 0xb5b5,	/*  */
	0xbfcb, 0xb5b7,	/*  */
	0xbfcc, 0xb5b9,	/*  */
	0xbfcd, 0xb5c1,	/*  */
	0xbfce, 0xb5c2,	/*  */
	0xbfcf, 0xb5c5,	/*  */
	0xbfd0, 0xb5c9,	/*  */
	0xbfd1, 0xb5d1,	/*  */
	0xbfd2, 0xb5d3,	/*  */
	0xbfd3, 0xb5d5,	/*  */
	0xbfd4, 0xb5d6,	/*  */
	0xbfd5, 0xb5d7,	/*  */
	0xbfd6, 0xb5e1,	/*  */
	0xbfd7, 0xb5e2,	/*  */
	0xbfd8, 0xb5e5,	/*  */
	0xbfd9, 0xb5f1,	/*  */
	0xbfda, 0xb5f5,	/*  */
	0xbfdb, 0xb5f7,	/*  */
	0xbfdc, 0xb641,	/*  */
	0xbfdd, 0xb642,	/*  */
	0xbfde, 0xb645,	/*  */
	0xbfdf, 0xb649,	/*  */
	0xbfe0, 0xb651,	/*  */
	0xbfe1, 0xb653,	/*  */
	0xbfe2, 0xb655,	/*  */
	0xbfe3, 0xb657,	/*  */
	0xbfe4, 0xb661,	/*  */
	0xbfe5, 0xb662,	/*  */
	0xbfe6, 0xb665,	/*  */
	0xbfe7, 0xb669,	/*  */
	0xbfe8, 0xb671,	/*  */
	0xbfe9, 0xb673,	/*  */
	0xbfea, 0xb675,	/*  */
	0xbfeb, 0xb677,	/*  */
	0xbfec, 0xb681,	/*  */
	0xbfed, 0xb682,	/*  */
	0xbfee, 0xb685,	/*  */
	0xbfef, 0xb689,	/*  */
	0xbff0, 0xb68a,	/*  */
	0xbff1, 0xb68b,	/*  */
	0xbff2, 0xb691,	/*  */
	0xbff3, 0xb693,	/*  */
	0xbff4, 0xb695,	/*  */
	0xbff5, 0xb697,	/*  */
	0xbff6, 0xb6a1,	/*  */
	0xbff7, 0xb6a2,	/*  */
	0xbff8, 0xb6a5,	/*  */
	0xbff9, 0xb6a9,	/*  */
	0xbffa, 0xb6b1,	/*  */
	0xbffb, 0xb6b3,	/*  */
	0xbffc, 0xb6b6,	/*  */
	0xbffd, 0xb6b7,	/*  */
	0xbffe, 0xb6c1,	/*  */
	0xc0a1, 0xb6c2,	/*  */
	0xc0a2, 0xb6c5,	/*  */
	0xc0a3, 0xb6c9,	/*  */
	0xc0a4, 0xb6d1,	/*  */
	0xc0a5, 0xb6d3,	/*  */
	0xc0a6, 0xb6d7,	/*  */
	0xc0a7, 0xb6e1,	/*  */
	0xc0a8, 0xb6e2,	/*  */
	0xc0a9, 0xb6e5,	/*  */
	0xc0aa, 0xb6e9,	/*  */
	0xc0ab, 0xb6f1,	/*  */
	0xc0ac, 0xb6f3,	/*  */
	0xc0ad, 0xb6f5,	/*  */
	0xc0ae, 0xb6f7,	/*  */
	0xc0af, 0xb741,	/*  */
	0xc0b0, 0xb742,	/*  */
	0xc0b1, 0xb745,	/*  */
	0xc0b2, 0xb749,	/*  */
	0xc0b3, 0xb751,	/*  */
	0xc0b4, 0xb753,	/*  */
	0xc0b5, 0xb755,	/*  */
	0xc0b6, 0xb757,	/*  */
	0xc0b7, 0xb759,	/*  */
	0xc0b8, 0xb761,	/*  */
	0xc0b9, 0xb762,	/*  */
	0xc0ba, 0xb765,	/*  */
	0xc0bb, 0xb769,	/*  */
	0xc0bc, 0xb76f,	/*  */
	0xc0bd, 0xb771,	/*  */
	0xc0be, 0xb773,	/*  */
	0xc0bf, 0xb775,	/*  */
	0xc0c0, 0xb777,	/*  */
	0xc0c1, 0xb778,	/*  */
	0xc0c2, 0xb779,	/*  */
	0xc0c3, 0xb77a,	/*  */
	0xc0c4, 0xb77b,	/*  */
	0xc0c5, 0xb77c,	/*  */
	0xc0c6, 0xb77d,	/*  */
	0xc0c7, 0xb781,	/*  */
	0xc0c8, 0xb785,	/*  */
	0xc0c9, 0xb789,	/*  */
	0xc0ca, 0xb791,	/*  */
	0xc0cb, 0xb795,	/*  */
	0xc0cc, 0xb7a1,	/*  */
	0xc0cd, 0xb7a2,	/*  */
	0xc0ce, 0xb7a5,	/*  */
	0xc0cf, 0xb7a9,	/*  */
	0xc0d0, 0xb7aa,	/*  */
	0xc0d1, 0xb7ab,	/*  */
	0xc0d2, 0xb7b0,	/*  */
	0xc0d3, 0xb7b1,	/*  */
	0xc0d4, 0xb7b3,	/*  */
	0xc0d5, 0xb7b5,	/*  */
	0xc0d6, 0xb7b6,	/*  */
	0xc0d7, 0xb7b7,	/*  */
	0xc0d8, 0xb7b8,	/*  */
	0xc0d9, 0xb7bc,	/*  */
	0xc0da, 0xb861,	/*  */
	0xc0db, 0xb862,	/*  */
	0xc0dc, 0xb865,	/*  */
	0xc0dd, 0xb867,	/*  */
	0xc0de, 0xb868,	/*  */
	0xc0df, 0xb869,	/*  */
	0xc0e0, 0xb86b,	/*  */
	0xc0e1, 0xb871,	/*  */
	0xc0e2, 0xb873,	/*  */
	0xc0e3, 0xb875,	/*  */
	0xc0e4, 0xb876,	/*  */
	0xc0e5, 0xb877,	/*  */
	0xc0e6, 0xb878,	/*  */
	0xc0e7, 0xb881,	/*  */
	0xc0e8, 0xb882,	/*  */
	0xc0e9, 0xb885,	/*  */
	0xc0ea, 0xb889,	/*  */
	0xc0eb, 0xb891,	/*  */
	0xc0ec, 0xb893,	/*  */
	0xc0ed, 0xb895,	/*  */
	0xc0ee, 0xb896,	/*  */
	0xc0ef, 0xb897,	/*  */
	0xc0f0, 0xb8a1,	/*  */
	0xc0f1, 0xb8a2,	/*  */
	0xc0f2, 0xb8a5,	/*  */
	0xc0f3, 0xb8a7,	/*  */
	0xc0f4, 0xb8a9,	/*  */
	0xc0f5, 0xb8b1,	/*  */
	0xc0f6, 0xb8b7,	/*  */
	0xc0f7, 0xb8c1,	/*  */
	0xc0f8, 0xb8c5,	/*  */
	0xc0f9, 0xb8c9,	/*  */
	0xc0fa, 0xb8e1,	/*  */
	0xc0fb, 0xb8e2,	/*  */
	0xc0fc, 0xb8e5,	/*  */
	0xc0fd, 0xb8e9,	/*  */
	0xc0fe, 0xb8eb,	/*  */
	0xc1a1, 0xb8f1,	/*  */
	0xc1a2, 0xb8f3,	/*  */
	0xc1a3, 0xb8f5,	/*  */
	0xc1a4, 0xb8f7,	/*  */
	0xc1a5, 0xb8f8,	/*  */
	0xc1a6, 0xb941,	/*  */
	0xc1a7, 0xb942,	/*  */
	0xc1a8, 0xb945,	/*  */
	0xc1a9, 0xb949,	/*  */
	0xc1aa, 0xb951,	/*  */
	0xc1ab, 0xb953,	/*  */
	0xc1ac, 0xb955,	/*  */
	0xc1ad, 0xb957,	/*  */
	0xc1ae, 0xb961,	/*  */
	0xc1af, 0xb965,	/*  */
	0xc1b0, 0xb969,	/*  */
	0xc1b1, 0xb971,	/*  */
	0xc1b2, 0xb973,	/*  */
	0xc1b3, 0xb976,	/*  */
	0xc1b4, 0xb977,	/*  */
	0xc1b5, 0xb981,	/*  */
	0xc1b6, 0xb9a1,	/*  */
	0xc1b7, 0xb9a2,	/*  */
	0xc1b8, 0xb9a5,	/*  */
	0xc1b9, 0xb9a9,	/*  */
	0xc1ba, 0xb9ab,	/*  */
	0xc1bb, 0xb9b1,	/*  */
	0xc1bc, 0xb9b3,	/*  */
	0xc1bd, 0xb9b5,	/*  */
	0xc1be, 0xb9b7,	/*  */
	0xc1bf, 0xb9b8,	/*  */
	0xc1c0, 0xb9b9,	/*  */
	0xc1c1, 0xb9bd,	/*  */
	0xc1c2, 0xb9c1,	/*  */
	0xc1c3, 0xb9c2,	/*  */
	0xc1c4, 0xb9c9,	/*  */
	0xc1c5, 0xb9d3,	/*  */
	0xc1c6, 0xb9d5,	/*  */
	0xc1c7, 0xb9d7,	/*  */
	0xc1c8, 0xb9e1,	/*  */
	0xc1c9, 0xb9f6,	/*  */
	0xc1ca, 0xb9f7,	/*  */
	0xc1cb, 0xba41,	/*  */
	0xc1cc, 0xba45,	/*  */
	0xc1cd, 0xba49,	/*  */
	0xc1ce, 0xba51,	/*  */
	0xc1cf, 0xba53,	/*  */
	0xc1d0, 0xba55,	/*  */
	0xc1d1, 0xba57,	/*  */
	0xc1d2, 0xba61,	/*  */
	0xc1d3, 0xba62,	/*  */
	0xc1d4, 0xba65,	/*  */
	0xc1d5, 0xba77,	/*  */
	0xc1d6, 0xba81,	/*  */
	0xc1d7, 0xba82,	/*  */
	0xc1d8, 0xba85,	/*  */
	0xc1d9, 0xba89,	/*  */
	0xc1da, 0xba8a,	/*  */
	0xc1db, 0xba8b,	/*  */
	0xc1dc, 0xba91,	/*  */
	0xc1dd, 0xba93,	/*  */
	0xc1de, 0xba95,	/*  */
	0xc1df, 0xba97,	/*  */
	0xc1e0, 0xbaa1,	/*  */
	0xc1e1, 0xbab6,	/*  */
	0xc1e2, 0xbac1,	/*  */
	0xc1e3, 0xbae1,	/*  */
	0xc1e4, 0xbae2,	/*  */
	0xc1e5, 0xbae5,	/*  */
	0xc1e6, 0xbae9,	/*  */
	0xc1e7, 0xbaf1,	/*  */
	0xc1e8, 0xbaf3,	/*  */
	0xc1e9, 0xbaf5,	/*  */
	0xc1ea, 0xbb41,	/*  */
	0xc1eb, 0xbb45,	/*  */
	0xc1ec, 0xbb49,	/*  */
	0xc1ed, 0xbb51,	/*  */
	0xc1ee, 0xbb61,	/*  */
	0xc1ef, 0xbb62,	/*  */
	0xc1f0, 0xbb65,	/*  */
	0xc1f1, 0xbb69,	/*  */
	0xc1f2, 0xbb71,	/*  */
	0xc1f3, 0xbb73,	/*  */
	0xc1f4, 0xbb75,	/*  */
	0xc1f5, 0xbb77,	/*  */
	0xc1f6, 0xbba1,	/*  */
	0xc1f7, 0xbba2,	/*  */
	0xc1f8, 0xbba5,	/*  */
	0xc1f9, 0xbba8,	/*  */
	0xc1fa, 0xbba9,	/*  */
	0xc1fb, 0xbbab,	/*  */
	0xc1fc, 0xbbb1,	/*  */
	0xc1fd, 0xbbb3,	/*  */
	0xc1fe, 0xbbb5,	/*  */
	0xc2a1, 0xbbb7,	/* ¡ */
	0xc2a2, 0xbbb8,	/* ¢ */
	0xc2a3, 0xbbbb,	/* £ */
	0xc2a4, 0xbbbc,	/* ¤ */
	0xc2a5, 0xbc61,	/* ¥ */
	0xc2a6, 0xbc62,	/* ¦ */
	0xc2a7, 0xbc65,	/* § */
	0xc2a8, 0xbc67,	/* ¨ */
	0xc2a9, 0xbc69,	/* © */
	0xc2aa, 0xbc6c,	/* ª */
	0xc2ab, 0xbc71,	/* « */
	0xc2ac, 0xbc73,	/* ¬ */
	0xc2ad, 0xbc75,	/* ­ */
	0xc2ae, 0xbc76,	/* ® */
	0xc2af, 0xbc77,	/* ¯ */
	0xc2b0, 0xbc81,	/* ° */
	0xc2b1, 0xbc82,	/* ± */
	0xc2b2, 0xbc85,	/* ² */
	0xc2b3, 0xbc89,	/* ³ */
	0xc2b4, 0xbc91,	/* ´ */
	0xc2b5, 0xbc93,	/* µ */
	0xc2b6, 0xbc95,	/* ¶ */
	0xc2b7, 0xbc96,	/* · */
	0xc2b8, 0xbc97,	/* ¸ */
	0xc2b9, 0xbca1,	/* ¹ */
	0xc2ba, 0xbca5,	/* º */
	0xc2bb, 0xbcb7,	/* » */
	0xc2bc, 0xbce1,	/* ¼ */
	0xc2bd, 0xbce2,	/* ½ */
	0xc2be, 0xbce5,	/* ¾ */
	0xc2bf, 0xbce9,	/* ¿ */
	0xc2c0, 0xbcf1,	/*  */
	0xc2c1, 0xbcf3,	/*  */
	0xc2c2, 0xbcf5,	/*  */
	0xc2c3, 0xbcf6,	/*  */
	0xc2c4, 0xbcf7,	/*  */
	0xc2c5, 0xbd41,	/*  */
	0xc2c6, 0xbd57,	/*  */
	0xc2c7, 0xbd61,	/*  */
	0xc2c8, 0xbd76,	/*  */
	0xc2c9, 0xbda1,	/*  */
	0xc2ca, 0xbda2,	/*  */
	0xc2cb, 0xbda5,	/*  */
	0xc2cc, 0xbda9,	/*  */
	0xc2cd, 0xbdb1,	/*  */
	0xc2ce, 0xbdb3,	/*  */
	0xc2cf, 0xbdb5,	/*  */
	0xc2d0, 0xbdb7,	/*  */
	0xc2d1, 0xbdb9,	/*  */
	0xc2d2, 0xbdc1,	/*  */
	0xc2d3, 0xbdc2,	/*  */
	0xc2d4, 0xbdc9,	/*  */
	0xc2d5, 0xbdd6,	/*  */
	0xc2d6, 0xbde1,	/*  */
	0xc2d7, 0xbdf6,	/*  */
	0xc2d8, 0xbe41,	/*  */
	0xc2d9, 0xbe45,	/*  */
	0xc2da, 0xbe49,	/*  */
	0xc2db, 0xbe51,	/*  */
	0xc2dc, 0xbe53,	/*  */
	0xc2dd, 0xbe77,	/*  */
	0xc2de, 0xbe81,	/*  */
	0xc2df, 0xbe82,	/*  */
	0xc2e0, 0xbe85,	/*  */
	0xc2e1, 0xbe89,	/*  */
	0xc2e2, 0xbe91,	/*  */
	0xc2e3, 0xbe93,	/*  */
	0xc2e4, 0xbe97,	/*  */
	0xc2e5, 0xbea1,	/*  */
	0xc2e6, 0xbeb6,	/*  */
	0xc2e7, 0xbeb7,	/*  */
	0xc2e8, 0xbee1,	/*  */
	0xc2e9, 0xbf41,	/*  */
	0xc2ea, 0xbf61,	/*  */
	0xc2eb, 0xbf71,	/*  */
	0xc2ec, 0xbf75,	/*  */
	0xc2ed, 0xbf77,	/*  */
	0xc2ee, 0xbfa1,	/*  */
	0xc2ef, 0xbfa2,	/*  */
	0xc2f0, 0xbfa5,	/*  */
	0xc2f1, 0xbfa9,	/*  */
	0xc2f2, 0xbfb1,	/*  */
	0xc2f3, 0xbfb3,	/*  */
	0xc2f4, 0xbfb7,	/*  */
	0xc2f5, 0xbfb8,	/*  */
	0xc2f6, 0xbfbd,	/*  */
	0xc2f7, 0xc061,	/*  */
	0xc2f8, 0xc062,	/*  */
	0xc2f9, 0xc065,	/*  */
	0xc2fa, 0xc067,	/*  */
	0xc2fb, 0xc069,	/*  */
	0xc2fc, 0xc071,	/*  */
	0xc2fd, 0xc073,	/*  */
	0xc2fe, 0xc075,	/*  */
	0xc3a1, 0xc076,	/* á */
	0xc3a2, 0xc077,	/* â */
	0xc3a3, 0xc078,	/* ã */
	0xc3a4, 0xc081,	/* ä */
	0xc3a5, 0xc082,	/* å */
	0xc3a6, 0xc085,	/* æ */
	0xc3a7, 0xc089,	/* ç */
	0xc3a8, 0xc091,	/* è */
	0xc3a9, 0xc093,	/* é */
	0xc3aa, 0xc095,	/* ê */
	0xc3ab, 0xc096,	/* ë */
	0xc3ac, 0xc097,	/* ì */
	0xc3ad, 0xc0a1,	/* í */
	0xc3ae, 0xc0a5,	/* î */
	0xc3af, 0xc0a7,	/* ï */
	0xc3b0, 0xc0a9,	/* ð */
	0xc3b1, 0xc0b1,	/* ñ */
	0xc3b2, 0xc0b7,	/* ò */
	0xc3b3, 0xc0e1,	/* ó */
	0xc3b4, 0xc0e2,	/* ô */
	0xc3b5, 0xc0e5,	/* õ */
	0xc3b6, 0xc0e9,	/* ö */
	0xc3b7, 0xc0f1,	/* ÷ */
	0xc3b8, 0xc0f3,	/* ø */
	0xc3b9, 0xc0f5,	/* ù */
	0xc3ba, 0xc0f6,	/* ú */
	0xc3bb, 0xc0f7,	/* û */
	0xc3bc, 0xc141,	/* ü */
	0xc3bd, 0xc142,	/* ý */
	0xc3be, 0xc145,	/* þ */
	0xc3bf, 0xc149,	/* ÿ */
	0xc3c0, 0xc151,	/*  */
	0xc3c1, 0xc153,	/*  */
	0xc3c2, 0xc155,	/*  */
	0xc3c3, 0xc157,	/*  */
	0xc3c4, 0xc161,	/*  */
	0xc3c5, 0xc165,	/*  */
	0xc3c6, 0xc176,	/*  */
	0xc3c7, 0xc181,	/*  */
	0xc3c8, 0xc185,	/*  */
	0xc3c9, 0xc197,	/*  */
	0xc3ca, 0xc1a1,	/*  */
	0xc3cb, 0xc1a2,	/*  */
	0xc3cc, 0xc1a5,	/*  */
	0xc3cd, 0xc1a9,	/*  */
	0xc3ce, 0xc1b1,	/*  */
	0xc3cf, 0xc1b3,	/*  */
	0xc3d0, 0xc1b5,	/*  */
	0xc3d1, 0xc1b7,	/*  */
	0xc3d2, 0xc1c1,	/*  */
	0xc3d3, 0xc1c5,	/*  */
	0xc3d4, 0xc1c9,	/*  */
	0xc3d5, 0xc1d7,	/*  */
	0xc3d6, 0xc241,	/*  */
	0xc3d7, 0xc245,	/*  */
	0xc3d8, 0xc249,	/*  */
	0xc3d9, 0xc251,	/*  */
	0xc3da, 0xc253,	/*  */
	0xc3db, 0xc255,	/*  */
	0xc3dc, 0xc257,	/*  */
	0xc3dd, 0xc261,	/*  */
	0xc3de, 0xc271,	/*  */
	0xc3df, 0xc281,	/*  */
	0xc3e0, 0xc282,	/*  */
	0xc3e1, 0xc285,	/*  */
	0xc3e2, 0xc289,	/*  */
	0xc3e3, 0xc291,	/*  */
	0xc3e4, 0xc293,	/*  */
	0xc3e5, 0xc295,	/*  */
	0xc3e6, 0xc297,	/*  */
	0xc3e7, 0xc2a1,	/*  */
	0xc3e8, 0xc2b6,	/*  */
	0xc3e9, 0xc2c1,	/*  */
	0xc3ea, 0xc2c5,	/*  */
	0xc3eb, 0xc2e1,	/*  */
	0xc3ec, 0xc2e5,	/*  */
	0xc3ed, 0xc2e9,	/*  */
	0xc3ee, 0xc2f1,	/*  */
	0xc3ef, 0xc2f3,	/*  */
	0xc3f0, 0xc2f5,	/*  */
	0xc3f1, 0xc2f7,	/*  */
	0xc3f2, 0xc341,	/*  */
	0xc3f3, 0xc345,	/*  */
	0xc3f4, 0xc349,	/*  */
	0xc3f5, 0xc351,	/*  */
	0xc3f6, 0xc357,	/*  */
	0xc3f7, 0xc361,	/*  */
	0xc3f8, 0xc362,	/*  */
	0xc3f9, 0xc365,	/*  */
	0xc3fa, 0xc369,	/*  */
	0xc3fb, 0xc371,	/*  */
	0xc3fc, 0xc373,	/*  */
	0xc3fd, 0xc375,	/*  */
	0xc3fe, 0xc377,	/*  */
	0xc4a1, 0xc3a1,	/* ġ */
	0xc4a2, 0xc3a2,	/* Ģ */
	0xc4a3, 0xc3a5,	/* ģ */
	0xc4a4, 0xc3a8,	/* Ĥ */
	0xc4a5, 0xc3a9,	/* ĥ */
	0xc4a6, 0xc3aa,	/* Ħ */
	0xc4a7, 0xc3b1,	/* ħ */
	0xc4a8, 0xc3b3,	/* Ĩ */
	0xc4a9, 0xc3b5,	/* ĩ */
	0xc4aa, 0xc3b7,	/* Ī */
	0xc4ab, 0xc461,	/* ī */
	0xc4ac, 0xc462,	/* Ĭ */
	0xc4ad, 0xc465,	/* ĭ */
	0xc4ae, 0xc469,	/* Į */
	0xc4af, 0xc471,	/* į */
	0xc4b0, 0xc473,	/* İ */
	0xc4b1, 0xc475,	/* ı */
	0xc4b2, 0xc477,	/* Ĳ */
	0xc4b3, 0xc481,	/* ĳ */
	0xc4b4, 0xc482,	/* Ĵ */
	0xc4b5, 0xc485,	/* ĵ */
	0xc4b6, 0xc489,	/* Ķ */
	0xc4b7, 0xc491,	/* ķ */
	0xc4b8, 0xc493,	/* ĸ */
	0xc4b9, 0xc495,	/* Ĺ */
	0xc4ba, 0xc496,	/* ĺ */
	0xc4bb, 0xc497,	/* Ļ */
	0xc4bc, 0xc4a1,	/* ļ */
	0xc4bd, 0xc4a2,	/* Ľ */
	0xc4be, 0xc4b7,	/* ľ */
	0xc4bf, 0xc4e1,	/* Ŀ */
	0xc4c0, 0xc4e2,	/*  */
	0xc4c1, 0xc4e5,	/*  */
	0xc4c2, 0xc4e8,	/*  */
	0xc4c3, 0xc4e9,	/*  */
	0xc4c4, 0xc4f1,	/*  */
	0xc4c5, 0xc4f3,	/*  */
	0xc4c6, 0xc4f5,	/*  */
	0xc4c7, 0xc4f6,	/*  */
	0xc4c8, 0xc4f7,	/*  */
	0xc4c9, 0xc541,	/*  */
	0xc4ca, 0xc542,	/*  */
	0xc4cb, 0xc545,	/*  */
	0xc4cc, 0xc549,	/*  */
	0xc4cd, 0xc551,	/*  */
	0xc4ce, 0xc553,	/*  */
	0xc4cf, 0xc555,	/*  */
	0xc4d0, 0xc557,	/*  */
	0xc4d1, 0xc561,	/*  */
	0xc4d2, 0xc565,	/*  */
	0xc4d3, 0xc569,	/*  */
	0xc4d4, 0xc571,	/*  */
	0xc4d5, 0xc573,	/*  */
	0xc4d6, 0xc575,	/*  */
	0xc4d7, 0xc576,	/*  */
	0xc4d8, 0xc577,	/*  */
	0xc4d9, 0xc581,	/*  */
	0xc4da, 0xc5a1,	/*  */
	0xc4db, 0xc5a2,	/*  */
	0xc4dc, 0xc5a5,	/*  */
	0xc4dd, 0xc5a9,	/*  */
	0xc4de, 0xc5b1,	/*  */
	0xc4df, 0xc5b3,	/*  */
	0xc4e0, 0xc5b5,	/*  */
	0xc4e1, 0xc5b7,	/*  */
	0xc4e2, 0xc5c1,	/*  */
	0xc4e3, 0xc5c2,	/*  */
	0xc4e4, 0xc5c5,	/*  */
	0xc4e5, 0xc5c9,	/*  */
	0xc4e6, 0xc5d1,	/*  */
	0xc4e7, 0xc5d7,	/*  */
	0xc4e8, 0xc5e1,	/*  */
	0xc4e9, 0xc5f7,	/*  */
	0xc4ea, 0xc641,	/*  */
	0xc4eb, 0xc649,	/*  */
	0xc4ec, 0xc661,	/*  */
	0xc4ed, 0xc681,	/*  */
	0xc4ee, 0xc682,	/*  */
	0xc4ef, 0xc685,	/*  */
	0xc4f0, 0xc689,	/*  */
	0xc4f1, 0xc691,	/*  */
	0xc4f2, 0xc693,	/*  */
	0xc4f3, 0xc695,	/*  */
	0xc4f4, 0xc697,	/*  */
	0xc4f5, 0xc6a1,	/*  */
	0xc4f6, 0xc6a5,	/*  */
	0xc4f7, 0xc6a9,	/*  */
	0xc4f8, 0xc6b7,	/*  */
	0xc4f9, 0xc6c1,	/*  */
	0xc4fa, 0xc6d7,	/*  */
	0xc4fb, 0xc6e1,	/*  */
	0xc4fc, 0xc6e2,	/*  */
	0xc4fd, 0xc6e5,	/*  */
	0xc4fe, 0xc6e9,	/*  */
	0xc5a1, 0xc6f1,	/* š */
	0xc5a2, 0xc6f3,	/* Ţ */
	0xc5a3, 0xc6f5,	/* ţ */
	0xc5a4, 0xc6f7,	/* Ť */
	0xc5a5, 0xc741,	/* ť */
	0xc5a6, 0xc745,	/* Ŧ */
	0xc5a7, 0xc749,	/* ŧ */
	0xc5a8, 0xc751,	/* Ũ */
	0xc5a9, 0xc761,	/* ũ */
	0xc5aa, 0xc762,	/* Ū */
	0xc5ab, 0xc765,	/* ū */
	0xc5ac, 0xc769,	/* Ŭ */
	0xc5ad, 0xc771,	/* ŭ */
	0xc5ae, 0xc773,	/* Ů */
	0xc5af, 0xc777,	/* ů */
	0xc5b0, 0xc7a1,	/* Ű */
	0xc5b1, 0xc7a2,	/* ű */
	0xc5b2, 0xc7a5,	/* Ų */
	0xc5b3, 0xc7a9,	/* ų */
	0xc5b4, 0xc7b1,	/* Ŵ */
	0xc5b5, 0xc7b3,	/* ŵ */
	0xc5b6, 0xc7b5,	/* Ŷ */
	0xc5b7, 0xc7b7,	/* ŷ */
	0xc5b8, 0xc861,	/* Ÿ */
	0xc5b9, 0xc862,	/* Ź */
	0xc5ba, 0xc865,	/* ź */
	0xc5bb, 0xc869,	/* Ż */
	0xc5bc, 0xc86a,	/* ż */
	0xc5bd, 0xc871,	/* Ž */
	0xc5be, 0xc873,	/* ž */
	0xc5bf, 0xc875,	/* ſ */
	0xc5c0, 0xc876,	/*  */
	0xc5c1, 0xc877,	/*  */
	0xc5c2, 0xc881,	/*  */
	0xc5c3, 0xc882,	/*  */
	0xc5c4, 0xc885,	/*  */
	0xc5c5, 0xc889,	/*  */
	0xc5c6, 0xc891,	/*  */
	0xc5c7, 0xc893,	/*  */
	0xc5c8, 0xc895,	/*  */
	0xc5c9, 0xc896,	/*  */
	0xc5ca, 0xc897,	/*  */
	0xc5cb, 0xc8a1,	/*  */
	0xc5cc, 0xc8b7,	/*  */
	0xc5cd, 0xc8e1,	/*  */
	0xc5ce, 0xc8e2,	/*  */
	0xc5cf, 0xc8e5,	/*  */
	0xc5d0, 0xc8e9,	/*  */
	0xc5d1, 0xc8eb,	/*  */
	0xc5d2, 0xc8f1,	/*  */
	0xc5d3, 0xc8f3,	/*  */
	0xc5d4, 0xc8f5,	/*  */
	0xc5d5, 0xc8f6,	/*  */
	0xc5d6, 0xc8f7,	/*  */
	0xc5d7, 0xc941,	/*  */
	0xc5d8, 0xc942,	/*  */
	0xc5d9, 0xc945,	/*  */
	0xc5da, 0xc949,	/*  */
	0xc5db, 0xc951,	/*  */
	0xc5dc, 0xc953,	/*  */
	0xc5dd, 0xc955,	/*  */
	0xc5de, 0xc957,	/*  */
	0xc5df, 0xc961,	/*  */
	0xc5e0, 0xc965,	/*  */
	0xc5e1, 0xc976,	/*  */
	0xc5e2, 0xc981,	/*  */
	0xc5e3, 0xc985,	/*  */
	0xc5e4, 0xc9a1,	/*  */
	0xc5e5, 0xc9a2,	/*  */
	0xc5e6, 0xc9a5,	/*  */
	0xc5e7, 0xc9a9,	/*  */
	0xc5e8, 0xc9b1,	/*  */
	0xc5e9, 0xc9b3,	/*  */
	0xc5ea, 0xc9b5,	/*  */
	0xc5eb, 0xc9b7,	/*  */
	0xc5ec, 0xc9bc,	/*  */
	0xc5ed, 0xc9c1,	/*  */
	0xc5ee, 0xc9c5,	/*  */
	0xc5ef, 0xc9e1,	/*  */
	0xc5f0, 0xca41,	/*  */
	0xc5f1, 0xca45,	/*  */
	0xc5f2, 0xca55,	/*  */
	0xc5f3, 0xca57,	/*  */
	0xc5f4, 0xca61,	/*  */
	0xc5f5, 0xca81,	/*  */
	0xc5f6, 0xca82,	/*  */
	0xc5f7, 0xca85,	/*  */
	0xc5f8, 0xca89,	/*  */
	0xc5f9, 0xca91,	/*  */
	0xc5fa, 0xca93,	/*  */
	0xc5fb, 0xca95,	/*  */
	0xc5fc, 0xca97,	/*  */
	0xc5fd, 0xcaa1,	/*  */
	0xc5fe, 0xcab6,	/*  */
	0xc6a1, 0xcac1,	/* ơ */
	0xc6a2, 0xcae1,	/* Ƣ */
	0xc6a3, 0xcae2,	/* ƣ */
	0xc6a4, 0xcae5,	/* Ƥ */
	0xc6a5, 0xcae9,	/* ƥ */
	0xc6a6, 0xcaf1,	/* Ʀ */
	0xc6a7, 0xcaf3,	/* Ƨ */
	0xc6a8, 0xcaf7,	/* ƨ */
	0xc6a9, 0xcb41,	/* Ʃ */
	0xc6aa, 0xcb45,	/* ƪ */
	0xc6ab, 0xcb49,	/* ƫ */
	0xc6ac, 0xcb51,	/* Ƭ */
	0xc6ad, 0xcb57,	/* ƭ */
	0xc6ae, 0xcb61,	/* Ʈ */
	0xc6af, 0xcb62,	/* Ư */
	0xc6b0, 0xcb65,	/* ư */
	0xc6b1, 0xcb68,	/* Ʊ */
	0xc6b2, 0xcb69,	/* Ʋ */
	0xc6b3, 0xcb6b,	/* Ƴ */
	0xc6b4, 0xcb71,	/* ƴ */
	0xc6b5, 0xcb73,	/* Ƶ */
	0xc6b6, 0xcb75,	/* ƶ */
	0xc6b7, 0xcb81,	/* Ʒ */
	0xc6b8, 0xcb85,	/* Ƹ */
	0xc6b9, 0xcb89,	/* ƹ */
	0xc6ba, 0xcb91,	/* ƺ */
	0xc6bb, 0xcb93,	/* ƻ */
	0xc6bc, 0xcba1,	/* Ƽ */
	0xc6bd, 0xcba2,	/* ƽ */
	0xc6be, 0xcba5,	/* ƾ */
	0xc6bf, 0xcba9,	/* ƿ */
	0xc6c0, 0xcbb1,	/*  */
	0xc6c1, 0xcbb3,	/*  */
	0xc6c2, 0xcbb5,	/*  */
	0xc6c3, 0xcbb7,	/*  */
	0xc6c4, 0xcc61,	/*  */
	0xc6c5, 0xcc62,	/*  */
	0xc6c6, 0xcc63,	/*  */
	0xc6c7, 0xcc65,	/*  */
	0xc6c8, 0xcc69,	/*  */
	0xc6c9, 0xcc6b,	/*  */
	0xc6ca, 0xcc71,	/*  */
	0xc6cb, 0xcc73,	/*  */
	0xc6cc, 0xcc75,	/*  */
	0xc6cd, 0xcc76,	/*  */
	0xc6ce, 0xcc77,	/*  */
	0xc6cf, 0xcc7b,	/*  */
	0xc6d0, 0xcc81,	/*  */
	0xc6d1, 0xcc82,	/*  */
	0xc6d2, 0xcc85,	/*  */
	0xc6d3, 0xcc89,	/*  */
	0xc6d4, 0xcc91,	/*  */
	0xc6d5, 0xcc93,	/*  */
	0xc6d6, 0xcc95,	/*  */
	0xc6d7, 0xcc96,	/*  */
	0xc6d8, 0xcc97,	/*  */
	0xc6d9, 0xcca1,	/*  */
	0xc6da, 0xcca2,	/*  */
	0xc6db, 0xcce1,	/*  */
	0xc6dc, 0xcce2,	/*  */
	0xc6dd, 0xcce5,	/*  */
	0xc6de, 0xcce9,	/*  */
	0xc6df, 0xccf1,	/*  */
	0xc6e0, 0xccf3,	/*  */
	0xc6e1, 0xccf5,	/*  */
	0xc6e2, 0xccf6,	/*  */
	0xc6e3, 0xccf7,	/*  */
	0xc6e4, 0xcd41,	/*  */
	0xc6e5, 0xcd42,	/*  */
	0xc6e6, 0xcd45,	/*  */
	0xc6e7, 0xcd49,	/*  */
	0xc6e8, 0xcd51,	/*  */
	0xc6e9, 0xcd53,	/*  */
	0xc6ea, 0xcd55,	/*  */
	0xc6eb, 0xcd57,	/*  */
	0xc6ec, 0xcd61,	/*  */
	0xc6ed, 0xcd65,	/*  */
	0xc6ee, 0xcd69,	/*  */
	0xc6ef, 0xcd71,	/*  */
	0xc6f0, 0xcd73,	/*  */
	0xc6f1, 0xcd76,	/*  */
	0xc6f2, 0xcd77,	/*  */
	0xc6f3, 0xcd81,	/*  */
	0xc6f4, 0xcd89,	/*  */
	0xc6f5, 0xcd93,	/*  */
	0xc6f6, 0xcd95,	/*  */
	0xc6f7, 0xcda1,	/*  */
	0xc6f8, 0xcda2,	/*  */
	0xc6f9, 0xcda5,	/*  */
	0xc6fa, 0xcda9,	/*  */
	0xc6fb, 0xcdb1,	/*  */
	0xc6fc, 0xcdb3,	/*  */
	0xc6fd, 0xcdb5,	/*  */
	0xc6fe, 0xcdb7,	/*  */
	0xc7a1, 0xcdc1,	/* ǡ */
	0xc7a2, 0xcdd7,	/* Ǣ */
	0xc7a3, 0xce41,	/* ǣ */
	0xc7a4, 0xce45,	/* Ǥ */
	0xc7a5, 0xce61,	/* ǥ */
	0xc7a6, 0xce65,	/* Ǧ */
	0xc7a7, 0xce69,	/* ǧ */
	0xc7a8, 0xce73,	/* Ǩ */
	0xc7a9, 0xce75,	/* ǩ */
	0xc7aa, 0xce81,	/* Ǫ */
	0xc7ab, 0xce82,	/* ǫ */
	0xc7ac, 0xce85,	/* Ǭ */
	0xc7ad, 0xce88,	/* ǭ */
	0xc7ae, 0xce89,	/* Ǯ */
	0xc7af, 0xce8b,	/* ǯ */
	0xc7b0, 0xce91,	/* ǰ */
	0xc7b1, 0xce93,	/* Ǳ */
	0xc7b2, 0xce95,	/* ǲ */
	0xc7b3, 0xce97,	/* ǳ */
	0xc7b4, 0xcea1,	/* Ǵ */
	0xc7b5, 0xceb7,	/* ǵ */
	0xc7b6, 0xcee1,	/* Ƕ */
	0xc7b7, 0xcee5,	/* Ƿ */
	0xc7b8, 0xcee9,	/* Ǹ */
	0xc7b9, 0xcef1,	/* ǹ */
	0xc7ba, 0xcef5,	/* Ǻ */
	0xc7bb, 0xcf41,	/* ǻ */
	0xc7bc, 0xcf45,	/* Ǽ */
	0xc7bd, 0xcf49,	/* ǽ */
	0xc7be, 0xcf51,	/* Ǿ */
	0xc7bf, 0xcf55,	/* ǿ */
	0xc7c0, 0xcf57,	/*  */
	0xc7c1, 0xcf61,	/*  */
	0xc7c2, 0xcf65,	/*  */
	0xc7c3, 0xcf69,	/*  */
	0xc7c4, 0xcf71,	/*  */
	0xc7c5, 0xcf73,	/*  */
	0xc7c6, 0xcf75,	/*  */
	0xc7c7, 0xcfa1,	/*  */
	0xc7c8, 0xcfa2,	/*  */
	0xc7c9, 0xcfa5,	/*  */
	0xc7ca, 0xcfa9,	/*  */
	0xc7cb, 0xcfb1,	/*  */
	0xc7cc, 0xcfb3,	/*  */
	0xc7cd, 0xcfb5,	/*  */
	0xc7ce, 0xcfb7,	/*  */
	0xc7cf, 0xd061,	/*  */
	0xc7d0, 0xd062,	/*  */
	0xc7d1, 0xd065,	/*  */
	0xc7d2, 0xd069,	/*  */
	0xc7d3, 0xd06e,	/*  */
	0xc7d4, 0xd071,	/*  */
	0xc7d5, 0xd073,	/*  */
	0xc7d6, 0xd075,	/*  */
	0xc7d7, 0xd077,	/*  */
	0xc7d8, 0xd081,	/*  */
	0xc7d9, 0xd082,	/*  */
	0xc7da, 0xd085,	/*  */
	0xc7db, 0xd089,	/*  */
	0xc7dc, 0xd091,	/*  */
	0xc7dd, 0xd093,	/*  */
	0xc7de, 0xd095,	/*  */
	0xc7df, 0xd096,	/*  */
	0xc7e0, 0xd097,	/*  */
	0xc7e1, 0xd0a1,	/*  */
	0xc7e2, 0xd0b7,	/*  */
	0xc7e3, 0xd0e1,	/*  */
	0xc7e4, 0xd0e2,	/*  */
	0xc7e5, 0xd0e5,	/*  */
	0xc7e6, 0xd0e9,	/*  */
	0xc7e7, 0xd0eb,	/*  */
	0xc7e8, 0xd0f1,	/*  */
	0xc7e9, 0xd0f3,	/*  */
	0xc7ea, 0xd0f5,	/*  */
	0xc7eb, 0xd0f7,	/*  */
	0xc7ec, 0xd141,	/*  */
	0xc7ed, 0xd142,	/*  */
	0xc7ee, 0xd145,	/*  */
	0xc7ef, 0xd149,	/*  */
	0xc7f0, 0xd151,	/*  */
	0xc7f1, 0xd153,	/*  */
	0xc7f2, 0xd155,	/*  */
	0xc7f3, 0xd157,	/*  */
	0xc7f4, 0xd161,	/*  */
	0xc7f5, 0xd162,	/*  */
	0xc7f6, 0xd165,	/*  */
	0xc7f7, 0xd169,	/*  */
	0xc7f8, 0xd171,	/*  */
	0xc7f9, 0xd173,	/*  */
	0xc7fa, 0xd175,	/*  */
	0xc7fb, 0xd176,	/*  */
	0xc7fc, 0xd177,	/*  */
	0xc7fd, 0xd181,	/*  */
	0xc7fe, 0xd185,	/*  */
	0xc8a1, 0xd189,	/* ȡ */
	0xc8a2, 0xd193,	/* Ȣ */
	0xc8a3, 0xd1a1,	/* ȣ */
	0xc8a4, 0xd1a2,	/* Ȥ */
	0xc8a5, 0xd1a5,	/* ȥ */
	0xc8a6, 0xd1a9,	/* Ȧ */
	0xc8a7, 0xd1ae,	/* ȧ */
	0xc8a8, 0xd1b1,	/* Ȩ */
	0xc8a9, 0xd1b3,	/* ȩ */
	0xc8aa, 0xd1b5,	/* Ȫ */
	0xc8ab, 0xd1b7,	/* ȫ */
	0xc8ac, 0xd1bb,	/* Ȭ */
	0xc8ad, 0xd1c1,	/* ȭ */
	0xc8ae, 0xd1c2,	/* Ȯ */
	0xc8af, 0xd1c5,	/* ȯ */
	0xc8b0, 0xd1c9,	/* Ȱ */
	0xc8b1, 0xd1d5,	/* ȱ */
	0xc8b2, 0xd1d7,	/* Ȳ */
	0xc8b3, 0xd1e1,	/* ȳ */
	0xc8b4, 0xd1e2,	/* ȴ */
	0xc8b5, 0xd1e5,	/* ȵ */
	0xc8b6, 0xd1f5,	/* ȶ */
	0xc8b7, 0xd1f7,	/* ȷ */
	0xc8b8, 0xd241,	/* ȸ */
	0xc8b9, 0xd242,	/* ȹ */
	0xc8ba, 0xd245,	/* Ⱥ */
	0xc8bb, 0xd249,	/* Ȼ */
	0xc8bc, 0xd253,	/* ȼ */
	0xc8bd, 0xd255,	/* Ƚ */
	0xc8be, 0xd257,	/* Ⱦ */
	0xc8bf, 0xd261,	/* ȿ */
	0xc8c0, 0xd265,	/*  */
	0xc8c1, 0xd269,	/*  */
	0xc8c2, 0xd273,	/*  */
	0xc8c3, 0xd275,	/*  */
	0xc8c4, 0xd281,	/*  */
	0xc8c5, 0xd282,	/*  */
	0xc8c6, 0xd285,	/*  */
	0xc8c7, 0xd289,	/*  */
	0xc8c8, 0xd28e,	/*  */
	0xc8c9, 0xd291,	/*  */
	0xc8ca, 0xd295,	/*  */
	0xc8cb, 0xd297,	/*  */
	0xc8cc, 0xd2a1,	/*  */
	0xc8cd, 0xd2a5,	/*  */
	0xc8ce, 0xd2a9,	/*  */
	0xc8cf, 0xd2b1,	/*  */
	0xc8d0, 0xd2b7,	/*  */
	0xc8d1, 0xd2c1,	/*  */
	0xc8d2, 0xd2c2,	/*  */
	0xc8d3, 0xd2c5,	/*  */
	0xc8d4, 0xd2c9,	/*  */
	0xc8d5, 0xd2d7,	/*  */
	0xc8d6, 0xd2e1,	/*  */
	0xc8d7, 0xd2e2,	/*  */
	0xc8d8, 0xd2e5,	/*  */
	0xc8d9, 0xd2e9,	/*  */
	0xc8da, 0xd2f1,	/*  */
	0xc8db, 0xd2f3,	/*  */
	0xc8dc, 0xd2f5,	/*  */
	0xc8dd, 0xd2f7,	/*  */
	0xc8de, 0xd341,	/*  */
	0xc8df, 0xd342,	/*  */
	0xc8e0, 0xd345,	/*  */
	0xc8e1, 0xd349,	/*  */
	0xc8e2, 0xd351,	/*  */
	0xc8e3, 0xd355,	/*  */
	0xc8e4, 0xd357,	/*  */
	0xc8e5, 0xd361,	/*  */
	0xc8e6, 0xd362,	/*  */
	0xc8e7, 0xd365,	/*  */
	0xc8e8, 0xd367,	/*  */
	0xc8e9, 0xd368,	/*  */
	0xc8ea, 0xd369,	/*  */
	0xc8eb, 0xd36a,	/*  */
	0xc8ec, 0xd371,	/*  */
	0xc8ed, 0xd373,	/*  */
	0xc8ee, 0xd375,	/*  */
	0xc8ef, 0xd377,	/*  */
	0xc8f0, 0xd37b,	/*  */
	0xc8f1, 0xd381,	/*  */
	0xc8f2, 0xd385,	/*  */
	0xc8f3, 0xd389,	/*  */
	0xc8f4, 0xd391,	/*  */
	0xc8f5, 0xd393,	/*  */
	0xc8f6, 0xd397,	/*  */
	0xc8f7, 0xd3a1,	/*  */
	0xc8f8, 0xd3a2,	/*  */
	0xc8f9, 0xd3a5,	/*  */
	0xc8fa, 0xd3a9,	/*  */
	0xc8fb, 0xd3b1,	/*  */
	0xc8fc, 0xd3b3,	/*  */
	0xc8fd, 0xd3b5,	/*  */
	0xc8fe, 0xd3b7	/*  */
};
