/*
	Hangul code conversion program.
	This program was implemented only for a test purpose
	that code conversion table can be very small.

	KSC 5601-1987 complete code <--> KSSM composite code

	<Caution> This program is VERY VERY INEFFICIENT because
		code conversion table is encoded as bit string.
		So, it is recommended that you may use it only for
		small text file.
*/

#include <stdio.h>
#include "hcodetab.h"

/*
	Code range of the KS C 5601 low bytes.
*/
#define LOWB	0x5e	/* sizeof low-byte: from 0xa1 to 0xfe */
#define SKIP	0xa2	/* sizeof skipped : from 0xff to 0xa0 */

#define LINESIZE	999

unsigned char line[LINESIZE];
unsigned char line2[LINESIZE];

/*
	Syllable to syllable code conversion.
	Standard complete(KS C 5601) to Sambo composite(KSSM) code.
*/
ksc2kssm(high, low, line2)
unsigned char high, low;
unsigned char *line2;
{
	unsigned syl;
	unsigned i, j, m, n;

	if (high < 0xb0 || high > 0xc8 || low < 0xa1)
		return;	/* incomplete syllable */

	syl = ((high << 8) & 0xff00) | (low & 0xff);

	n = syl - 0xb0a0;
	n = n - (n / 256) * SKIP;	/* n-th KSC syllable */

	for (m=i=0; i < BTABSIZE && m < n; i++)
		for (j = 0; j < 8; j++)
			if ((BitTab[i] >> j) & 0x01)
				if (++m == n) break;
	i--;
	syl = 0x8861 + i*8+j;
	*line2 = (syl >> 8) & 0xff;	/* KSC high byte */
	*(line2+1) = syl & 0xff;	/* KSC low byte  */
}

/*
	Syllable to syllable code conversion.
	Sambo composite(KSSM) to standard complete(KS C 5601) code.
*/
kssm2ksc(high, low, line2)
unsigned char high, low;
unsigned char *line2;
{
	unsigned syl, m;
	unsigned i, j, n, r;

	syl = ((high << 8) & 0xff00) | (low & 0xff);

	n = syl - 0x8860;	/* n-th KSSM syllable(?) */

	/* calculate m-th KSC from n-th KSSM */
	r = n % 8; n /= 8;
	for (m=i=0; i < n; i++)
		for (j = 0; j < 8; j++)
			if ((BitTab[i] >> j) & 0x01) m++;
	for (j = 0; j < r; j++)
		if ((BitTab[i] >> j) & 0x01) m++;

	syl = 0xb0a0 + m;	/* m-th KSC syllable */
	syl += ((m-1) / LOWB) * SKIP;	/* adjust skipped area */

	*line2 = (syl >> 8) & 0xff;	/* KSSM high byte */
	*(line2+1) = syl & 0xff;	/* KSSM low byte  */
}

/*
	Line to line code conversion.
	Sambo composite(KSSM) to complete(KS C 5601) code, and vice versa.
*/
codeconv(line1, line2, sylconv)
unsigned char *line1, *line2;
void (*sylconv)();
{
	while (*line1) {
		if ((*line1 & 0x80) && *(line1+1)) {	/* Hangul syllable */
			(*sylconv)(*line1, *(line1+1), line2);
			line1 += 2; line2 += 2;
		} else *line2++ = *line1++;	/* non-Hangul char. */
	}
	*line2 = '\0';
}

synopsis()
{
	printf("\n\tusage: kscode -{1/2} infile outfile\n");
	printf("\n\t  option -1 : KSSM --> KSC5601\n");
	printf("\t         -2 : KSC5601 --> KSSM\n\n");
	printf("\tHansung University, Kang Seung-Shik\n");
}

main(argc, argv)
int argc;
char *argv[];
{
	int hflag;
	FILE *fpin, *fpout;

	if (argv[1][0] != '-') {
		synopsis();
		exit(-1);
	}

	switch (argc) {
	case 2:
		fpin = stdin;
		fpout = stdout;
		break;
	case 3:
		fpin = fopen(argv[2], "r");
		fpout = stdout;
		break;
	case 4:
		fpin = fopen(argv[2], "r");
		fpout = fopen(argv[3], "w");
		break;
	default:
		synopsis();
		exit(-1);
	}

	hflag = (argv[1][1] == '2') ? 1 : 0;

	while (fgets(line, LINESIZE-1, fpin)) {
		if (hflag)
			codeconv(line, line2, ksc2kssm);
		else
			codeconv(line, line2, kssm2ksc);
		fprintf(fpout, "%s", line2);
	}
}

