/*
	A simple program to generate 'hcodetab.h' from 'ksc2kssm.h'.
*/

#include <stdio.h>
#include "ksc2kssm.h"

#define BTABSIZE	2411

main()
{
	int i, j1, j2;
	char btab[BTABSIZE];
	unsigned int k;
	char tmp;

	for (i = 0; i < BTABSIZE; i++) btab[i] = 0;

	for (i = 0; i < 2350; i++) {
		k = hcode[i][1] - 0x8861;
if (k < 0) printf("Error : %d\n", i);
		j1 = k / 8;
		j2 = k % 8;
tmp = btab[j1];
		btab[j1] = btab[j1] | (0x01 << j2);
if (tmp == btab[j1]) printf("Error-2: %d, 0x%x, delta= %d, tmp= %x, j1= %d, j2= %d\n", i, hcode[i][1], k, tmp, j1, j2);
	}

	printf("#define BTABSIZE	2411\n\n");
	printf("unsigned char BitTab[BTABSIZE] = {\n");
	printf("\t");

	for (i = 0; i < BTABSIZE; i++) {
		if ((i % 10) == 9) {
			if (btab[i] & 0xf0)
				printf("0x%x,\n\t", btab[i] & 0xff);
			else
				printf("0x0%x,\n\t", btab[i] & 0xff);
		} else {
			if (btab[i] & 0xf0)
				printf("0x%x, ", btab[i] & 0xff);
			else
				printf("0x0%x, ", btab[i] & 0xff);
		}
	}

	printf("\n};");
}

