/*
	Specified no. of lines are printed at one line.
	When Hangul word is printed at each line with some information,
		3 or 4 lines are printed at one line.
	So, lots of data can be printed at one page.

	It is very similar to multi-step editing function of wordprocessor.
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>

int FIELD_SIZE = 11;
int NWORDS_PER_LINE = 5;

main(argc, argv)
int argc; char *argv[];
{
	FILE *fpin;
	FILE *fpout;
	char line[1000];
	int i = 0;
	int nargs = argc;
	int fpos = 1;

	if (argc > 1 && isdigit(argv[1][0])) {
		NWORDS_PER_LINE = atoi(argv[1]);
		nargs--;
		fpos++;
	}
	if (argc > 2 && argv[fpos][0] == '-') {
		FIELD_SIZE = atoi(argv[fpos]+1);
		nargs--;
	}

	if (nargs == 1) {
		printf("usage: nwords [n] [-xx] input-file [output-file]\n");
		printf("\t n  --- number of words per line (default: 5)\n");
		printf("\t-xx --- field size of each word (default: 11)\n");
		printf("(c) Hansung University. I wish you a good luck with it.\n");
		return;
	}

	if (nargs == 2) {
		fpin = fopen(argv[argc-1], "rb");
		fpout = stdout;
	} else {
		fpin = fopen(argv[argc-2], "rb");
		if (fpout = fopen(argv[argc-1], "r")) {
			perror("\nOutput file exists. Delete it first.");
			exit(-1);
		}
		fpout = fopen(argv[argc-1], "w");
	}

	while (fgets(line, 999, fpin)) {
		if (line[strlen(line)-2] == 0xd)
			line[strlen(line)-2] = 0;	/* remove CRLF */
		else line[strlen(line)-1] = 0;	/* remove CRLF */

		fprintf(fpout, "%s", line);
		if (i != NWORDS_PER_LINE-1)
			PutBlanks(strlen(line)-2, fpout);
		else
			fprintf(fpout, "\n");
		i = (i == NWORDS_PER_LINE-1) ? 0 : i+1;
	}
}

PutBlanks(n, fp)
int n;
FILE *fp;
{
	int i;

	for (i = n; i < FIELD_SIZE; i++)
		fprintf(fp, " ");
}

