/*
	Check if Hangul data is listed in ascending order.
	If two adjacent lines are not ordered, then print out.
*/

#include <stdio.h>

main(argc, argv)
int argc; char *argv[];
{
	int flag, cmpflag, eqflag = 0;
	int nargs = argc, filendx = 1;
	char line[BUFSIZ], lin2[BUFSIZ];
	char s[BUFSIZ], t[BUFSIZ];
	char *p, *q;
	FILE *fp1, *fp2;

	if (argc > 1 && argv[1][0] == '-') { nargs--; filendx++; eqflag = 1; }
	if (nargs == 1) {
		printf("\n\tusage: sortchk [-e] infile outfile\n");
		exit(0);
	}

	fp1 = fopen(argv[filendx], "r");
	if (nargs == 2) fp2 = stdout;
	else fp2 = fopen(argv[filendx+1], "w");

	flag = fget_line(fp1, line);
	flag = fget_line(fp1, lin2);
	p = line; while (*p == ' ') p++;
	strcpy(s, p);
	while (flag != EOF) {
		q = lin2;
		while (*q == ' ' || *q == '\t')
			q++;	/* remove leading blanks */
		strcpy(t, q);
		cmpflag = hstrcmp(s, t);
		if (cmpflag > 0 || (eqflag && !cmpflag))
			fprintf(fp2, "< %s\n> %s\n", line, lin2);
		strcpy(line, lin2);
		strcpy(s, t);
		flag = fget_line(fp1, lin2);
	}
	fclose(fp1);
	fclose(fp2);
}

hstrcmp(s, t)
char *s, *t;
{
	char c,d;

	while (1) {
		c = *s++; d = *t++;
		if ((c & 0x80) && (d & 0x80)) {
			c &= 0x7f;
			d &= 0x7f;
		} else if (c & 0x80) {
			return 1;
		} else if (d & 0x80) {
			return -1;
		}
		if (c != d) return c-d;
		else if (!c) return 0;
	}
}

fget_line(fp, line)
char *line;
FILE *fp;
{
	int c;

	while ((c = getc(fp)) != '\n') {
		*line++ = c;
		if (c == EOF) {
			*(line-1) = '\0';
			return(EOF);
		}
	}
	*line = '\0';
	return(1);
}

