/*
[] - ڵȯ α׷ Ϻη ϱ  Լ eng2johab() 

 1. Title
	Unix Ǵ DOS command line ּҷ  α׷

 2. Function
	command line ϸ ã  ̸̳ substring
	µ, ѱ substring ** Էϴ
	ڵ KS ϼ ȯؼ ãش.

 3. Copyright
	 Ʈ δб ½   ֽϴ.

	 S/W 񿵸 θ   ,
	ٸ S/W Ϻη  쿡 ݵ copyright ؾ մϴ.

	S/W  Ǵ Ϻθ  S/W ϴ  ˴ϴ.

 4. Warranty & Disclaimer
	 S/W  Ǵ Ϻθ ϴٰ ߻  
	ڿ å , ڿԴ å ϴ.
	 S/W ԵǾ ִ ϼ<-> ڵ庯ȯ Լ bit 
	ϱ  ſ   Ƿ, Ϲ ڵ庯ȯ
	 ϴ  մϴ.

    (C) Seung-Shik Kang, Kookmin University, 2001. 4. 8.
*/
#include <stdio.h>
#include <string.h>

#define FILE_NAME	"C:/kang/phone"

/*
	Hangul code conversion program.
	This program was implemented only for a test purpose
	that code conversion table can be very small.

	KSC 5601-1987 complete code <--> KSSM composite code

	<Caution> This program is VERY VERY INEFFICIENT because
		code conversion table is encoded as bit string.
		So, it is recommended that you may use it only for
		small text file.
*/
#include "hcodetab.h"

/*
	Code range of the KS C 5601 low bytes.
*/
#define LOWB	0x5E	/* sizeof low-byte: from 0xa1 to 0xfe */
#define SKIP	0xA2	/* sizeof skipped : from 0xff to 0xa0 */

#define LINESIZE	999

/*
	Syllable to syllable code conversion.
	Standard complete(KS C 5601) to Sambo composite(KSSM) code.
*/
void ksc2kssm(high, low, line2)
unsigned char high, low;
unsigned char *line2;
{
	unsigned syl;
	unsigned i, j, m, n;

	if (high < 0xB0 || high > 0xC8 || low < 0xA1)
		return;	/* incomplete syllable */

	syl = ((high << 8) & 0xff00) | (low & 0xff);

	n = syl - 0xB0A0;
	n = n - (n / 256) * SKIP;	/* n-th KSC syllable */

	for (m=i=0; i < BTABSIZE && m < n; i++)
		for (j = 0; j < 8; j++)
			if ((BitTab[i] >> j) & 0x01)
				if (++m == n) break;
	i--;
	syl = 0x8861 + i*8+j;
	*line2 = (syl >> 8) & 0xff;	/* KSC high byte */
	*(line2+1) = syl & 0xff;	/* KSC low byte  */
}

/*
	Syllable to syllable code conversion.
	Sambo composite(KSSM) to standard complete(KS C 5601) code.
*/
void kssm2ksc(high, low, line2)
unsigned char high, low;
unsigned char *line2;
{
	unsigned syl, m;
	unsigned i, j, n, r;

	syl = ((high << 8) & 0xff00) | (low & 0xff);

	n = syl - 0x8860;	/* n-th KSSM syllable(?) */

	/* calculate m-th KSC from n-th KSSM */
	r = n % 8; n /= 8;
	for (m=i=0; i < n; i++)
		for (j = 0; j < 8; j++)
			if ((BitTab[i] >> j) & 0x01) m++;
	for (j = 0; j < r; j++)
		if ((BitTab[i] >> j) & 0x01) m++;

	syl = 0xb0a0 + m;	/* m-th KSC syllable */
	syl += ((m-1) / LOWB) * SKIP;	/* adjust skipped area */

	*line2 = (syl >> 8) & 0xff;	/* KSSM high byte */
	*(line2+1) = syl & 0xff;	/* KSSM low byte  */
}

/*
	Line to line code conversion.
	Sambo composite(KSSM) to complete(KS C 5601) code, and vice versa.

	Usage:
	  1. KSC5601 --> KSSM code
			codeconv(line1, line2, ksc2kssm);
	  2. KSSM code --> KSC5601
			codeconv(line1, line2, kssm2ksc);
*/
void codeconv(line1, line2, sylconv)
unsigned char *line1, *line2;
void (*sylconv)();
{
	while (*line1) {
		if ((*line1 & 0x80) && *(line1+1)) {	/* Hangul syllable */
			(*sylconv)(*line1, *(line1+1), line2);
			line1 += 2; line2 += 2;
		} else *line2++ = *line1++;	/* non-Hangul char. */
	}
	*line2 = '\0';
}
/*------------------ end of KSSM <--> KSC code conversion --------------------*/

#define LINESIZE	999
#define WORDSIZE	 99

#define NONE	0
#define JAEM	1
#define MOEM	2

#define CHO	1
#define JUNG	2
#define JONG	3
#define JONG2	4

/*
	Automatic conversion of English string to KSC 5601 word.
*/
unsigned char *jaem = "@@rRseEfaqQtTdwWczxvg";
unsigned char *moem = "@@@koiOj@@puPh@@@@@yn@@@@@bm@l";

unsigned char cho2jong[21] = {
	0,
	1,	/* FILL code */
	2,	/*  */
	3,	/*  */
	5,	/*  */
	8,	/*  */
	1,
	9,	/*  */
	17,	/*  */
	19,	/*  */
	1,
	21,	/*  */
	22,	/*  */
	23,	/*  */
	24,	/*  */
	1,
	25,	/*  */
	26,	/*  */
	27,	/*  */
	28,	/*  */
	29	/*  */
};

void eng2johab(estring, johab)
unsigned char *estring;	/* English keys for Hangul */
unsigned char *johab;	/* Johab Hangul string */
{
	int i, n=strlen(estring);
	unsigned char *p, *p1, *p2;

	unsigned syl[WORDSIZE], isyl=0;	/*  ڵ */
	int map[WORDSIZE]={0};	/* estring --> johab mapping index */

	int status=NONE;	/* Chosung ٸ  */
	int jamoflag;
	unsigned pre_jamo;	/* temporary */

	for (i = 0; i < n; i++) {
		if (p=strchr(jaem, estring[i])) jamoflag=JAEM;	/* Jaem */
		else if (p=strchr(moem, estring[i])) jamoflag=MOEM;	/* Moem */
		else {	/* ERROR --- none of Jaem, Moem */
			map[i] = isyl++;
			syl[isyl] = (unsigned) estring[i];
			status = NONE;
			continue;
		}

		switch (status) {
		case NONE:
			map[i] = isyl;
			if (jamoflag==JAEM) {	/*  */
				syl[isyl] = 0x8021 | ((p-jaem) << 10);
				status = CHO;
			} else if (jamoflag==MOEM) {	/* 0_ */
				syl[isyl] = 0x8401;
				syl[isyl] = (syl[isyl] & 0xfc1f) | ((p-moem) << 5);
				status = JUNG;
			}
			break;
		case CHO:
			if (jamoflag==JAEM) {	/* _ */
				map[i] = ++isyl;
				syl[isyl] = 0x8021 | ((p-jaem) << 10);
				status = CHO;
			} else if (jamoflag==MOEM) {	/* _ */
				syl[isyl] = (syl[isyl] & 0xfc1f) | ((p-moem) << 5);
				status = JUNG;
			}
			break;
		case JUNG:
			if (jamoflag==JAEM) {	/* x__ */
				syl[isyl] |= cho2jong[p-jaem];
				status = JONG;
			} else if (jamoflag==MOEM) {	/* x__ */
				pre_jamo = (syl[isyl] >> 5) & 0x1f;
				if (estring[i-1] == 'h' && estring[i] == 'k')	/*  */
					syl[isyl] = (syl[isyl] & 0xfc1f) | ((pre_jamo+1) << 5);
				else if (estring[i-1] == 'h' && estring[i] == 'o')	/*  */
					syl[isyl] = (syl[isyl] & 0xfc1f) | ((pre_jamo+2) << 5);
				else if (estring[i-1] == 'h' && estring[i] == 'l')	/*  */
					syl[isyl] = (syl[isyl] & 0xfc1f) | ((pre_jamo+5) << 5);
				else if (estring[i-1] == 'n' && estring[i] == 'j')	/*  */
					syl[isyl] = (syl[isyl] & 0xfc1f) | ((pre_jamo+1) << 5);
				else if (estring[i-1] == 'n' && estring[i] == 'p')	/*  */
					syl[isyl] = (syl[isyl] & 0xfc1f) | ((pre_jamo+2) << 5);
				else if (estring[i-1] == 'n' && estring[i] == 'l')	/*  */
					syl[isyl] = (syl[isyl] & 0xfc1f) | ((pre_jamo+3) << 5);
				else if (estring[i-1] == 'm' && estring[i] == 'l')	/*  */
					syl[isyl] = (syl[isyl] & 0xfc1f) | ((pre_jamo+1) << 5);
				else {	/* Error */
					map[i] = ++isyl;
					syl[isyl] = 0x8401;
					syl[isyl] = (syl[isyl] & 0xfc1f) | ((p-moem) << 5);
				}
			}
			break;
		case JONG:
			if (jamoflag==JAEM) {	/* x___ */
				if (estring[i-1] == 'r' && estring[i] == 't') {	/**/
					syl[isyl] += 2;
					status = JONG2;
				} else if (estring[i-1] == 's' && estring[i] == 'w') {	/**/
					syl[isyl] ++;
					status = JONG2;
				} else if (estring[i-1] == 's' && estring[i] == 'g') {	/**/
					syl[isyl] += 2;
					status = JONG2;
				} else if (estring[i-1] == 'f' && estring[i] == 'r') {	/**/
					syl[isyl] ++;
					status = JONG2;
				} else if (estring[i-1] == 'f' && estring[i] == 'a') {	/**/
					syl[isyl] += 2;
					status = JONG2;
				} else if (estring[i-1] == 'f' && estring[i] == 'q') {	/**/
					syl[isyl] += 3;
					status = JONG2;
				} else if (estring[i-1] == 'f' && estring[i] == 't') {	/**/
					syl[isyl] += 4;
					status = JONG2;
				} else if (estring[i-1] == 'f' && estring[i] == 'x') {	/**/
					syl[isyl] += 5;
					status = JONG2;
				} else if (estring[i-1] == 'f' && estring[i] == 'v') {	/**/
					syl[isyl] += 6;
					status = JONG2;
				} else if (estring[i-1] == 'f' && estring[i] == 'g') {	/**/
					syl[isyl] += 7;
					status = JONG2;
				} else if (estring[i-1] == 'q' && estring[i] == 't') {	/**/
					syl[isyl] += 2;
					status = JONG2;
				} else {
					map[i] = ++isyl;
					syl[isyl] = 0x8021 | ((p-jaem) << 10);
					status = CHO;
				}
			} else if (jamoflag==MOEM) {	/* x___ */
				syl[isyl] = syl[isyl] & 0xffe1;
				map[i] = ++isyl;
				syl[isyl] = 0x8001 | ((p1-jaem) << 10) |
					(p-moem) << 5;
				status = JUNG;
			}
			break;
		case JONG2:
			if (jamoflag==JAEM) {	/* x___ */
				map[i] = ++isyl;
				syl[isyl] = 0x8021 | ((p-jaem) << 10);
				status = CHO;
			} else if (jamoflag==MOEM) {	/* x___ */
				syl[isyl] = syl[isyl] & 0xffe0;
				syl[isyl] |= cho2jong[p2-jaem];

				map[i] = ++isyl;
				syl[isyl] = 0x8001 | ((p1-jaem) << 10) |
					(p-moem) << 5;
				status = JUNG;
			}
			break;
		}
		p2 = p1;
		p1 = p;
	}

	for (i=0; i <= isyl; i++) {
		johab[2*i] = (syl[i] >> 8) & 0xff;
		johab[2*i+1] = syl[i] & 0xff;
	}	johab[2*i] = '\0';
}

/*
	English string --> KSSM string --> KSC5601 string.
*/
void string2kscword(name, name2)
unsigned char *name, *name2;
{
	unsigned char temp[LINESIZE];

	eng2johab(name, temp);	/* E to KSSM conversion */
	codeconv(temp, name2, kssm2ksc);
}
/*-------------- end of English string to KSC 5601 string --------------*/

void extract_lines(unsigned char *name)
{
	unsigned char line[LINESIZE];
	unsigned char name2[WORDSIZE];
	int count=0;	/* number of lines found */
	FILE *fp;

	if ((fp = fopen(FILE_NAME, "r")) == NULL) {
		perror(FILE_NAME); 
		return;
	}

	while (fgets(line, LINESIZE, fp)) {
		if (strstr(line, name)) {
			if (!count) putchar('\n');
			fputs(line, stdout); 	/* print line with 'name' */
			count++;
		}
	}

	if (!count) {
		rewind(fp);
		string2kscword(name, name2);	/* E to K conversion */
		while (fgets(line, LINESIZE, fp)) {
			if (strstr(line, name2)) {
				if (!count) putchar('\n');
				fputs(line, stdout);  	/* print line with 'name2' */
				count++;
			}
		}
	}

	fclose(fp);
}

main(int argc, char *argv[])
{
	unsigned char name[WORDSIZE];
	int i;

	if (argc > 1) {
		for (i = 1; i < argc; i++)
			extract_lines(argv[i]);
	} else {
		printf("Name: "); fgets(name, LINESIZE, stdin);
		extract_lines(name);
	}
}
/*--------------------------- end of MAIN --------------------------------*/
